/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.persistence.dao.impl;

import com.flipkart.flux.domain.State;
import com.flipkart.flux.domain.Status;
import com.flipkart.flux.persistence.DataSourceType;
import com.flipkart.flux.persistence.SelectDataSource;
import com.flipkart.flux.persistence.SessionFactoryContext;
import com.flipkart.flux.persistence.Storage;
import com.flipkart.flux.persistence.dao.iface.StatesDAO;
import com.flipkart.flux.persistence.dao.impl.AbstractDAO;
import com.flipkart.flux.shard.ShardId;
import com.google.inject.name.Named;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;

public class StatesDAOImpl
extends AbstractDAO<State>
implements StatesDAO {
    private static final String TABLE_NAME = "State";
    private static final String COLUMN_ATTEMPTED_NUM_OF_REPLAYABLE_RETRIES = "attemptedNumOfReplayableRetries";
    private static final String COLUMN_ID = "id";
    private static final String COLUMN_STATE_MACHINE_ID = "stateMachineId";
    private static final String FOR_UPDATE = "for update";

    @Inject
    public StatesDAOImpl(@Named(value="fluxSessionFactoriesContext") SessionFactoryContext sessionFactoryContext) {
        super(sessionFactoryContext);
    }

    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public void updateState(String stateMachineInstanceId, State state) {
        super.update(state);
    }

    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public void updateStatus(String stateMachineId, Long stateId, Status status) {
        Query query = this.currentSession().createQuery("update State set status = :status where id = :stateId and stateMachineId = :stateMachineId");
        query.setString("status", status != null ? status.toString() : null);
        query.setLong("stateId", stateId.longValue());
        query.setString(COLUMN_STATE_MACHINE_ID, stateMachineId);
        query.executeUpdate();
    }

    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public void updateStatus(String stateMachineInstanceId, List<State> states, Status status) {
        StringBuilder inClause = new StringBuilder();
        if (states != null && !states.isEmpty()) {
            inClause.append(" and id in (");
            for (State state : states) {
                inClause.append(state.getId()).append(",");
            }
        }
        inClause.deleteCharAt(inClause.length() - 1).append(")");
        Query query = this.currentSession().createQuery("update State set status = :status where stateMachineId = :stateMachineId".concat(inClause.toString()));
        query.setString("status", status != null ? status.toString() : null);
        query.setString(COLUMN_STATE_MACHINE_ID, stateMachineInstanceId);
        query.executeUpdate();
    }

    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public void updateRollbackStatus(String stateMachineId, Long stateId, Status rollbackStatus) {
        Query query = this.currentSession().createQuery("update State set rollbackStatus = :rollbackStatus where id = :stateId and stateMachineId = :stateMachineId");
        query.setString("rollbackStatus", rollbackStatus != null ? rollbackStatus.toString() : null);
        query.setLong("stateId", stateId.longValue());
        query.setString(COLUMN_STATE_MACHINE_ID, stateMachineId);
        query.executeUpdate();
    }

    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public void incrementRetryCount(String stateMachineId, Long stateId) {
        Query query = this.currentSession().createQuery("update State set attemptedNoOfRetries = attemptedNoOfRetries + 1 where id = :stateId and stateMachineId = :stateMachineId");
        query.setLong("stateId", stateId.longValue());
        query.setString(COLUMN_STATE_MACHINE_ID, stateMachineId);
        query.executeUpdate();
    }

    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public void incrementReplayableRetries(String stateMachineId, Long stateId, Short attemptedNumOfReplayableRetries) {
        Query query = this.currentSession().createQuery("update State set attemptedNumOfReplayableRetries = :attemptedNumOfReplayableRetries  where id = :stateId and stateMachineId = :stateMachineId");
        query.setLong("stateId", stateId.longValue());
        query.setString(COLUMN_STATE_MACHINE_ID, stateMachineId);
        query.setShort(COLUMN_ATTEMPTED_NUM_OF_REPLAYABLE_RETRIES, attemptedNumOfReplayableRetries.shortValue());
        query.executeUpdate();
    }

    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public State findById(String stateMachineId, Long id) {
        return (State)super.findByCompositeIdFromStateTable(State.class, stateMachineId, id);
    }

    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public List<State> findAllStatesForGivenStateIds(String stateMachineId, List<Long> stateIds) {
        String inClause = stateIds.toString().replace("[", "(").replace("]", ")");
        Query query = this.currentSession().createQuery("select s from State s where stateMachineId = :stateMachineId and id in " + inClause);
        query.setString(COLUMN_STATE_MACHINE_ID, stateMachineId);
        return query.list();
    }

    @SelectDataSource(type=DataSourceType.READ_ONLY, storage=Storage.SHARDED)
    public List<State> findErroredStates(ShardId shardId, String stateMachineName, Timestamp fromTime, Timestamp toTime) {
        ArrayList<Status> statuses = new ArrayList<Status>();
        statuses.add(Status.errored);
        return this.findStatesByStatus(shardId, stateMachineName, fromTime, toTime, null, statuses);
    }

    @Transactional
    @SelectDataSource(type=DataSourceType.READ_ONLY, storage=Storage.SHARDED)
    public List<State> findStatesByStatus(ShardId shardId, String stateMachineName, Timestamp fromTime, Timestamp toTime, String stateName, List<Status> statuses) {
        Query query;
        String queryString = "select state.stateMachineId, state.id, state.status from State state join StateMachine sm on sm.id = state.stateMachineId and sm.createdAt between :fromTime and :toTime and sm.name = :stateMachineName";
        if (statuses != null && !statuses.isEmpty()) {
            StringBuilder sb = new StringBuilder(" and state.status in (");
            for (Status status : statuses) {
                sb.append("'" + status.toString() + "',");
            }
            sb.deleteCharAt(sb.length() - 1).append(")");
            String statusClause = sb.toString();
            queryString = queryString.concat(statusClause);
        }
        if (stateName == null) {
            query = this.currentSession().createQuery(queryString);
        } else {
            query = this.currentSession().createQuery(queryString + " and state.name = :stateName");
            query.setString("stateName", stateName);
        }
        query.setString("stateMachineName", stateMachineName);
        query.setTimestamp("fromTime", (Date)fromTime);
        query.setTimestamp("toTime", (Date)toTime);
        return query.list();
    }

    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public List<State> findStatesByDependentEvent(String stateMachineId, String eventName) {
        Query query = this.currentSession().createQuery("select state from State state where stateMachineId = :stateMachineId and dependencies like :eventName");
        query.setString(COLUMN_STATE_MACHINE_ID, stateMachineId);
        query.setString("eventName", "%" + eventName + "%");
        return query.list();
    }

    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public Long findStateIdByEventName(String stateMachineId, String eventName) {
        NativeQuery query = this.currentSession().createSQLQuery("select id from States where `stateMachineId`= '" + stateMachineId + "' and dependencies like '%" + eventName + "%'");
        return ((BigInteger)query.uniqueResult()).longValue();
    }

    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public void updateExecutionVersion(String stateMachineId, Long stateId, Long executionVersion) {
        Query query = this.currentSession().createQuery("update State set executionVersion = :executionVersion where id = :stateId and stateMachineId = :stateMachineId");
        query.setLong("executionVersion", executionVersion.longValue());
        query.setLong("stateId", stateId.longValue());
        query.setString(COLUMN_STATE_MACHINE_ID, stateMachineId);
        query.executeUpdate();
    }

    public void updateExecutionVersion_NonTransactional(String stateMachineId, List<Long> stateIds, Long executionVersion, Session session) {
        String inClause = stateIds.toString().replace("[", "(").replace("]", ")");
        Query query = session.createQuery("update State set executionVersion= :executionVersion" + " where stateMachineId= :stateMachineId and id in ".concat(inClause.toString()));
        query.setLong("executionVersion", executionVersion.longValue());
        query.setString(COLUMN_STATE_MACHINE_ID, stateMachineId);
        query.executeUpdate();
    }

    public void updateStatus_NonTransactional(String stateMachineInstanceId, List<Long> stateIds, Status status, Session session) {
        String inClauseQuery = stateIds.toString().replace("[", "(").replace("]", ")");
        Query query = session.createQuery("update State set status = :status where stateMachineId = :stateMachineId and id in ".concat(inClauseQuery));
        query.setString("status", status != null ? status.toString() : null);
        query.setString(COLUMN_STATE_MACHINE_ID, stateMachineInstanceId);
        query.executeUpdate();
    }

    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public void updateReplayableRetries(String stateMachineId, Long stateId, Short replayableRetries) {
        Query query = this.currentSession().createQuery("update State set attemptedNumOfReplayableRetries = :attemptedNumOfReplayableRetries where id = :stateId and stateMachineId = :stateMachineId");
        query.setString(COLUMN_STATE_MACHINE_ID, stateMachineId);
        query.setLong("stateId", stateId.longValue());
        query.setShort(COLUMN_ATTEMPTED_NUM_OF_REPLAYABLE_RETRIES, replayableRetries.shortValue());
        query.executeUpdate();
    }

    public short findAttemptedNumOfReplayableRetriesByIdForUpdate_NonTransactional(String stateMachineId, Long stateId, Session session) {
        NativeQuery sqlQuery = this.currentSession().createSQLQuery("select attemptedNumOfReplayableRetries from States where id = :stateId and stateMachineId = :stateMachineId for update");
        sqlQuery.setLong("stateId", stateId.longValue());
        sqlQuery.setString(COLUMN_STATE_MACHINE_ID, stateMachineId);
        return Short.valueOf(sqlQuery.uniqueResult().toString());
    }

    public void updateAttemptedNumOfReplayableRetries_NonTransactional(String stateMachineId, Long stateId, short attemptedNumOfReplayableRetries, Session session) {
        Query query = session.createQuery("update State set attemptedNumOfReplayableRetries = :attemptedNumOfReplayableRetries where id = :stateId and stateMachineId = :stateMachineId");
        query.setLong(COLUMN_ATTEMPTED_NUM_OF_REPLAYABLE_RETRIES, (long)attemptedNumOfReplayableRetries);
        query.setLong("stateId", stateId.longValue());
        query.setString(COLUMN_STATE_MACHINE_ID, stateMachineId);
        query.executeUpdate();
    }
}

