/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.MigrationUtil;

import com.flipkart.polyguice.config.YamlConfiguration;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Singleton;
import liquibase.Contexts;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.resource.FileSystemResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.apache.commons.configuration.Configuration;

@Singleton
public class MigrationsRunner {
    @Inject
    private YamlConfiguration yamlConfiguration;

    public void migrate(String dbName) {
        try {
            Configuration configuration = this.yamlConfiguration.subset(dbName + ".Hibernate");
            Properties properties = new Properties();
            properties.put("user", configuration.getProperty("hibernate.connection.username"));
            properties.put("password", configuration.getProperty("hibernate.connection.password"));
            String url = (String)configuration.getProperty("hibernate.connection.url");
            Class.forName("com.mysql.jdbc.Driver").newInstance();
            Connection connection = DriverManager.getConnection(url, properties);
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(connection));
            ClassLoader classLoader = this.getClass().getClassLoader();
            File file = new File(classLoader.getResource(dbName + "/migrations.xml").getFile());
            Liquibase liquibase = new Liquibase(file.getCanonicalPath(), (ResourceAccessor)new FileSystemResourceAccessor(), database);
            liquibase.update(new Contexts());
        }
        catch (Exception e) {
            System.err.println("Unable to perform database migration.");
            e.printStackTrace();
        }
    }
}

