/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.MigrationUtil;

import com.flipkart.polyguice.config.YamlConfiguration;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Singleton;
import liquibase.Contexts;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.resource.FileSystemResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.apache.commons.configuration.Configuration;

@Singleton
public class MigrationsRunner {
    @Inject
    private YamlConfiguration yamlConfiguration;

    public void migrate() {
        try {
            Configuration configuration = this.yamlConfiguration.subset("Hibernate");
            Properties properties = new Properties();
            properties.put("user", configuration.getProperty("hibernate.connection.username"));
            properties.put("password", configuration.getProperty("hibernate.connection.password"));
            String url = (String)configuration.getProperty("hibernate.connection.url");
            Class.forName("com.mysql.jdbc.Driver").newInstance();
            Connection connection = DriverManager.getConnection(url, properties);
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(connection));
            Liquibase liquibase = new Liquibase("persistence-mysql/src/main/resources/migrations.xml", (ResourceAccessor)new FileSystemResourceAccessor(), database);
            liquibase.update(new Contexts());
        }
        catch (Exception e) {
            System.err.println("Unable to perform database migration.");
            e.printStackTrace();
        }
    }
}

