/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.domain;

import com.flipkart.flux.domain.Status;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="States")
@IdClass(value=StatePK.class)
public class State {
    private static final short DEFAULT_ATTEMPTED_REPLAYABLE_RETRIES = 0;
    private static final short MAX_REPLAYABLE_RETRIES = 5;
    @Id
    private Long id;
    @Id
    private String stateMachineId;
    private Long version;
    private String name;
    private String description;
    private String onEntryHook;
    private String task;
    private String onExitHook;
    private Long retryCount;
    private Long timeout;
    @Type(type="ListJsonType")
    private List<String> dependencies = new LinkedList<String>();
    private String outputEvent;
    @Enumerated(value=EnumType.STRING)
    private Status status;
    @Enumerated(value=EnumType.STRING)
    private Status rollbackStatus;
    private Long attemptedNoOfRetries;
    private Long executionVersion;
    private Boolean replayable;
    private Timestamp createdAt;
    @Column(updatable=false)
    private Timestamp updatedAt;
    private Short attemptedNumOfReplayableRetries;
    private Short maxReplayableRetries;

    protected State() {
    }

    public State(Long version, String name, String description, String onEntryHook, String task, String onExitHook, List<String> dependencies, Long retryCount, Long timeout, String outputEvent, Status status, Status rollbackStatus, Long attemptedNoOfRetries, String stateMachineId, Long id) {
        this(version, name, description, onEntryHook, task, onExitHook, dependencies, retryCount, timeout, outputEvent, status, rollbackStatus, attemptedNoOfRetries, stateMachineId, id, (short)5, (short)0, Boolean.FALSE, 0L);
    }

    public State(Long version, String name, String description, String onEntryHook, String task, String onExitHook, List<String> dependencies, Long retryCount, Long timeout, String outputEvent, Status status, Status rollbackStatus, Long attemptedNoOfRetries, String stateMachineId, Long id, Boolean replayable) {
        this(version, name, description, onEntryHook, task, onExitHook, dependencies, retryCount, timeout, outputEvent, status, rollbackStatus, attemptedNoOfRetries, stateMachineId, id, (short)5, (short)0, replayable, 0L);
    }

    public State(Long version, String name, String description, String onEntryHook, String task, String onExitHook, List<String> dependencies, Long retryCount, Long timeout, String outputEvent, Status status, Status rollbackStatus, Long attemptedNoOfRetries, String stateMachineId, Long id, Short maxReplayableRetries, Short attemptedNumOfReplayableRetries, Boolean replayable) {
        this(version, name, description, onEntryHook, task, onExitHook, dependencies, retryCount, timeout, outputEvent, status, rollbackStatus, attemptedNoOfRetries, stateMachineId, id, maxReplayableRetries, attemptedNumOfReplayableRetries, replayable, 0L);
    }

    public State(Long version, String name, String description, String onEntryHook, String task, String onExitHook, List<String> dependencies, Long retryCount, Long timeout, String outputEvent, Status status, Status rollbackStatus, Long attemptedNoOfRetries, String stateMachineId, Long id, Short maxReplayableRetryCount, Short attemptedNumOfReplayableRetries, Boolean replayable, Long executionVersion) {
        this();
        this.version = version;
        this.name = name;
        this.description = description;
        this.onEntryHook = onEntryHook;
        this.task = task;
        this.onExitHook = onExitHook;
        this.dependencies = dependencies;
        this.retryCount = retryCount;
        this.timeout = timeout;
        this.outputEvent = outputEvent;
        this.status = status;
        this.rollbackStatus = rollbackStatus;
        this.attemptedNoOfRetries = attemptedNoOfRetries;
        this.stateMachineId = stateMachineId;
        this.id = id;
        this.executionVersion = executionVersion;
        this.maxReplayableRetries = maxReplayableRetryCount;
        this.attemptedNumOfReplayableRetries = attemptedNumOfReplayableRetries;
        this.replayable = replayable;
    }

    public boolean isDependencySatisfied(Set<String> receivedEvents) {
        return receivedEvents.containsAll(this.dependencies);
    }

    public Long getId() {
        return this.id;
    }

    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getStateMachineId() {
        return this.stateMachineId;
    }

    public void setStateMachineId(String stateMachineId) {
        this.stateMachineId = stateMachineId;
    }

    public String getOnEntryHook() {
        return this.onEntryHook;
    }

    public void setOnEntryHook(String onEntryHook) {
        this.onEntryHook = onEntryHook;
    }

    public String getTask() {
        return this.task;
    }

    public void setTask(String task) {
        this.task = task;
    }

    public String getOnExitHook() {
        return this.onExitHook;
    }

    public void setOnExitHook(String onExitHook) {
        this.onExitHook = onExitHook;
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<String> dependencies) {
        this.dependencies = dependencies;
    }

    public Long getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(Long retryCount) {
        this.retryCount = retryCount;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Status getRollbackStatus() {
        return this.rollbackStatus;
    }

    public void setRollbackStatus(Status rollbackStatus) {
        this.rollbackStatus = rollbackStatus;
    }

    public Long getAttemptedNumOfRetries() {
        return this.attemptedNoOfRetries;
    }

    public void setAttemptedNumOfRetries(Long attemptedNoOfRetries) {
        this.attemptedNoOfRetries = attemptedNoOfRetries;
    }

    public Timestamp getCreatedAt() {
        return this.createdAt;
    }

    public Timestamp getUpdatedAt() {
        return this.updatedAt;
    }

    public String getOutputEvent() {
        return this.outputEvent;
    }

    public Long getExecutionVersion() {
        return this.executionVersion;
    }

    public void setExecutionVersion(Long executionVersion) {
        this.executionVersion = executionVersion;
    }

    public Boolean getReplayable() {
        return this.replayable;
    }

    public void setReplayable(Boolean replayable) {
        this.replayable = replayable;
    }

    public short getMaxReplayableRetries() {
        return this.maxReplayableRetries;
    }

    public void setMaxReplayableRetries(short maxReplayableRetries) {
        this.maxReplayableRetries = maxReplayableRetries;
    }

    public short getAttemptedNumOfReplayableRetries() {
        return this.attemptedNumOfReplayableRetries;
    }

    public void setAttemptedNumOfReplayableRetries(short attemptedNumOfReplayableRetries) {
        this.attemptedNumOfReplayableRetries = attemptedNumOfReplayableRetries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof State)) {
            return false;
        }
        State state = (State)o;
        if (this.createdAt != null ? !this.createdAt.equals(state.createdAt) : state.createdAt != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(state.description) : state.description != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(state.name) : state.name != null) {
            return false;
        }
        if (this.attemptedNoOfRetries != null ? !this.attemptedNoOfRetries.equals(state.attemptedNoOfRetries) : state.attemptedNoOfRetries != null) {
            return false;
        }
        if (this.onEntryHook != null ? !this.onEntryHook.equals(state.onEntryHook) : state.onEntryHook != null) {
            return false;
        }
        if (this.onExitHook != null ? !this.onExitHook.equals(state.onExitHook) : state.onExitHook != null) {
            return false;
        }
        if (this.outputEvent != null ? !this.outputEvent.equals(state.outputEvent) : state.outputEvent != null) {
            return false;
        }
        if (this.retryCount != null ? !this.retryCount.equals(state.retryCount) : state.retryCount != null) {
            return false;
        }
        if (this.rollbackStatus != state.rollbackStatus) {
            return false;
        }
        if (this.stateMachineId != null ? !this.stateMachineId.equals(state.stateMachineId) : state.stateMachineId != null) {
            return false;
        }
        if (this.status != state.status) {
            return false;
        }
        if (this.task != null ? !this.task.equals(state.task) : state.task != null) {
            return false;
        }
        if (this.timeout != null ? !this.timeout.equals(state.timeout) : state.timeout != null) {
            return false;
        }
        if (this.updatedAt != null ? !this.updatedAt.equals(state.updatedAt) : state.updatedAt != null) {
            return false;
        }
        if (this.version != null ? !this.version.equals(state.version) : state.version != null) {
            return false;
        }
        if (this.executionVersion != null ? !this.executionVersion.equals(state.executionVersion) : state.executionVersion != null) {
            return false;
        }
        if (this.replayable != null ? !this.replayable.equals(state.replayable) : state.replayable != null) {
            return false;
        }
        if (this.attemptedNumOfReplayableRetries != null ? !this.attemptedNumOfReplayableRetries.equals(state.attemptedNumOfReplayableRetries) : state.attemptedNumOfReplayableRetries != null) {
            return false;
        }
        return !(this.maxReplayableRetries != null ? !this.maxReplayableRetries.equals(state.maxReplayableRetries) : state.maxReplayableRetries != null);
    }

    public int hashCode() {
        int result = this.version != null ? this.version.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.stateMachineId != null ? this.stateMachineId.hashCode() : 0);
        result = 31 * result + (this.onEntryHook != null ? this.onEntryHook.hashCode() : 0);
        result = 31 * result + (this.task != null ? this.task.hashCode() : 0);
        result = 31 * result + (this.onExitHook != null ? this.onExitHook.hashCode() : 0);
        result = 31 * result + (this.outputEvent != null ? this.outputEvent.hashCode() : 0);
        result = 31 * result + (this.retryCount != null ? this.retryCount.hashCode() : 0);
        result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        result = 31 * result + (this.rollbackStatus != null ? this.rollbackStatus.hashCode() : 0);
        result = 31 * result + (this.attemptedNoOfRetries != null ? this.attemptedNoOfRetries.hashCode() : 0);
        result = 31 * result + (this.executionVersion != null ? this.executionVersion.hashCode() : 0);
        result = 31 * result + (this.replayable != null ? this.replayable.hashCode() : 0);
        result = 31 * result + (this.createdAt != null ? this.createdAt.hashCode() : 0);
        result = 31 * result + (this.updatedAt != null ? this.updatedAt.hashCode() : 0);
        result = 31 * result + (this.attemptedNumOfReplayableRetries != null ? this.attemptedNumOfReplayableRetries.hashCode() : 0);
        result = 31 * result + (this.maxReplayableRetries != null ? this.maxReplayableRetries.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "State{id=" + this.id + ", version=" + this.version + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", stateMachineId=" + this.stateMachineId + ", onEntryHook='" + this.onEntryHook + '\'' + ", task='" + this.task + '\'' + ", onExitHook='" + this.onExitHook + '\'' + ", outputEvent='" + this.outputEvent + '\'' + ", retryCount=" + this.retryCount + ", timeout=" + this.timeout + ", dependencies=" + this.dependencies + ", status=" + (Object)((Object)this.status) + ", rollbackStatus=" + (Object)((Object)this.rollbackStatus) + ", attemptedNoOfRetries=" + this.attemptedNoOfRetries + ", executionVersion=" + this.executionVersion + ", replayable=" + this.replayable + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", attemptedNumOfReplayableRetries=" + this.attemptedNumOfReplayableRetries + ", maxReplayableRetries=" + this.maxReplayableRetries + '}';
    }

    static class StatePK
    implements Serializable {
        private Long id;
        private String stateMachineId;

        public StatePK() {
        }

        public StatePK(Long id, String stateMachineId) {
            this.id = id;
            this.stateMachineId = stateMachineId;
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StatePK)) {
                return false;
            }
            StatePK statePK = (StatePK)o;
            if (!this.getId().equals(statePK.getId())) {
                return false;
            }
            return this.getStateMachineId().equals(statePK.getStateMachineId());
        }

        public int hashCode() {
            int result = this.getId().hashCode();
            result = 31 * result + this.getStateMachineId().hashCode();
            return result;
        }

        public String getStateMachineId() {
            return this.stateMachineId;
        }

        public void setStateMachineId(String stateMachineId) {
            this.stateMachineId = stateMachineId;
        }
    }
}

