/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.domain;

import com.flipkart.flux.domain.FluxError;
import com.flipkart.flux.domain.Status;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Type;

@Entity
@Table(name="States")
public class State {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    private Long version;
    private String name;
    private String description;
    private Long stateMachineId;
    private String onEntryHook;
    private String task;
    private String onExitHook;
    private Long retryCount;
    private Long timeout;
    @Type(type="SetJsonType")
    private Set<String> dependencies = new HashSet<String>();
    private String outputEvent;
    @Transient
    private List<FluxError> errors;
    @Enumerated(value=EnumType.STRING)
    private Status status;
    @Enumerated(value=EnumType.STRING)
    private Status rollbackStatus;
    private Long attemptedNoOfRetries;
    private Timestamp createdAt;
    private Timestamp updatedAt;

    protected State() {
    }

    public State(Long version, String name, String description, String onEntryHook, String task, String onExitHook, Set<String> dependencies, Long retryCount, Long timeout, String outputEvent, Status status, Status rollbackStatus, Long attemptedNoOfRetries) {
        this();
        this.version = version;
        this.name = name;
        this.description = description;
        this.onEntryHook = onEntryHook;
        this.task = task;
        this.onExitHook = onExitHook;
        this.dependencies = dependencies;
        this.retryCount = retryCount;
        this.timeout = timeout;
        this.outputEvent = outputEvent;
        this.status = status;
        this.rollbackStatus = rollbackStatus;
        this.attemptedNoOfRetries = attemptedNoOfRetries;
    }

    public boolean isDependencySatisfied(Set<String> receivedEvents) {
        return receivedEvents.containsAll(this.dependencies);
    }

    public Long getId() {
        return this.id;
    }

    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getStateMachineId() {
        return this.stateMachineId;
    }

    public void setStateMachineId(Long stateMachineId) {
        this.stateMachineId = stateMachineId;
    }

    public String getOnEntryHook() {
        return this.onEntryHook;
    }

    public void setOnEntryHook(String onEntryHook) {
        this.onEntryHook = onEntryHook;
    }

    public String getTask() {
        return this.task;
    }

    public void setTask(String task) {
        this.task = task;
    }

    public String getOnExitHook() {
        return this.onExitHook;
    }

    public void setOnExitHook(String onExitHook) {
        this.onExitHook = onExitHook;
    }

    public Set<String> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(Set<String> dependencies) {
        this.dependencies = dependencies;
    }

    public Long getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(Long retryCount) {
        this.retryCount = retryCount;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    public List<FluxError> getErrors() {
        return this.errors;
    }

    public void setErrors(List<FluxError> errors) {
        this.errors = errors;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Status getRollbackStatus() {
        return this.rollbackStatus;
    }

    public void setRollbackStatus(Status rollbackStatus) {
        this.rollbackStatus = rollbackStatus;
    }

    public Long getAttemptedNoOfRetries() {
        return this.attemptedNoOfRetries;
    }

    public void setAttemptedNoOfRetries(Long attemptedNoOfRetries) {
        this.attemptedNoOfRetries = attemptedNoOfRetries;
    }

    public String getOutputEvent() {
        return this.outputEvent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof State)) {
            return false;
        }
        State state = (State)o;
        if (this.createdAt != null ? !this.createdAt.equals(state.createdAt) : state.createdAt != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(state.description) : state.description != null) {
            return false;
        }
        if (this.errors != null ? !this.errors.equals(state.errors) : state.errors != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(state.name) : state.name != null) {
            return false;
        }
        if (this.attemptedNoOfRetries != null ? !this.attemptedNoOfRetries.equals(state.attemptedNoOfRetries) : state.attemptedNoOfRetries != null) {
            return false;
        }
        if (this.onEntryHook != null ? !this.onEntryHook.equals(state.onEntryHook) : state.onEntryHook != null) {
            return false;
        }
        if (this.onExitHook != null ? !this.onExitHook.equals(state.onExitHook) : state.onExitHook != null) {
            return false;
        }
        if (this.outputEvent != null ? !this.outputEvent.equals(state.outputEvent) : state.outputEvent != null) {
            return false;
        }
        if (this.retryCount != null ? !this.retryCount.equals(state.retryCount) : state.retryCount != null) {
            return false;
        }
        if (this.rollbackStatus != state.rollbackStatus) {
            return false;
        }
        if (this.stateMachineId != null ? !this.stateMachineId.equals(state.stateMachineId) : state.stateMachineId != null) {
            return false;
        }
        if (this.status != state.status) {
            return false;
        }
        if (this.task != null ? !this.task.equals(state.task) : state.task != null) {
            return false;
        }
        if (this.timeout != null ? !this.timeout.equals(state.timeout) : state.timeout != null) {
            return false;
        }
        if (this.updatedAt != null ? !this.updatedAt.equals(state.updatedAt) : state.updatedAt != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(state.version) : state.version != null);
    }

    public int hashCode() {
        int result = this.version != null ? this.version.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.stateMachineId != null ? this.stateMachineId.hashCode() : 0);
        result = 31 * result + (this.onEntryHook != null ? this.onEntryHook.hashCode() : 0);
        result = 31 * result + (this.task != null ? this.task.hashCode() : 0);
        result = 31 * result + (this.onExitHook != null ? this.onExitHook.hashCode() : 0);
        result = 31 * result + (this.outputEvent != null ? this.outputEvent.hashCode() : 0);
        result = 31 * result + (this.retryCount != null ? this.retryCount.hashCode() : 0);
        result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
        result = 31 * result + (this.errors != null ? this.errors.hashCode() : 0);
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        result = 31 * result + (this.rollbackStatus != null ? this.rollbackStatus.hashCode() : 0);
        result = 31 * result + (this.attemptedNoOfRetries != null ? this.attemptedNoOfRetries.hashCode() : 0);
        result = 31 * result + (this.createdAt != null ? this.createdAt.hashCode() : 0);
        result = 31 * result + (this.updatedAt != null ? this.updatedAt.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "State{id=" + this.id + ", version=" + this.version + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", stateMachineId=" + this.stateMachineId + ", onEntryHook='" + this.onEntryHook + '\'' + ", task='" + this.task + '\'' + ", onExitHook='" + this.onExitHook + '\'' + ", outputEvent='" + this.outputEvent + '\'' + ", retryCount=" + this.retryCount + ", timeout=" + this.timeout + ", dependencies=" + this.dependencies + ", errors=" + this.errors + ", status=" + (Object)((Object)this.status) + ", rollbackStatus=" + (Object)((Object)this.rollbackStatus) + ", attemptedNoOfRetries=" + this.attemptedNoOfRetries + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + '}';
    }
}

