/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.domain;

import com.flipkart.flux.domain.Status;
import java.sql.Timestamp;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name="AuditRecords")
public class AuditRecord {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    private Long stateMachineInstanceId;
    private Long stateId;
    private int retryAttempt;
    @Enumerated(value=EnumType.STRING)
    private Status stateStatus;
    @Enumerated(value=EnumType.STRING)
    private Status stateRollbackStatus;
    private String errors;
    private Timestamp createdAt;

    protected AuditRecord() {
    }

    public AuditRecord(Long stateMachineInstanceId, Long stateId, int retryAttempt, Status stateStatus, Status stateRollbackStatus, String errors) {
        this.stateMachineInstanceId = stateMachineInstanceId;
        this.stateId = stateId;
        this.retryAttempt = retryAttempt;
        this.stateStatus = stateStatus;
        this.stateRollbackStatus = stateRollbackStatus;
        this.errors = errors;
    }

    public Long getId() {
        return this.id;
    }

    public Long getStateMachineInstanceId() {
        return this.stateMachineInstanceId;
    }

    public void setStateMachineInstanceId(Long stateMachineInstanceId) {
        this.stateMachineInstanceId = stateMachineInstanceId;
    }

    public Long getStateId() {
        return this.stateId;
    }

    public void setStateId(Long stateId) {
        this.stateId = stateId;
    }

    public int getRetryAttempt() {
        return this.retryAttempt;
    }

    public void setRetryAttempt(int retryAttempt) {
        this.retryAttempt = retryAttempt;
    }

    public Status getStateStatus() {
        return this.stateStatus;
    }

    public void setStateStatus(Status stateStatus) {
        this.stateStatus = stateStatus;
    }

    public Status getStateRollbackStatus() {
        return this.stateRollbackStatus;
    }

    public void setStateRollbackStatus(Status stateRollbackStatus) {
        this.stateRollbackStatus = stateRollbackStatus;
    }

    public String getErrors() {
        return this.errors;
    }

    public void setErrors(String errors) {
        this.errors = errors;
    }

    public Timestamp getCreatedAt() {
        return this.createdAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuditRecord)) {
            return false;
        }
        AuditRecord that = (AuditRecord)o;
        if (this.retryAttempt != that.retryAttempt) {
            return false;
        }
        if (this.stateId != null ? !this.stateId.equals(that.stateId) : that.stateId != null) {
            return false;
        }
        if (this.stateMachineInstanceId != null ? !this.stateMachineInstanceId.equals(that.stateMachineInstanceId) : that.stateMachineInstanceId != null) {
            return false;
        }
        if (this.stateRollbackStatus != that.stateRollbackStatus) {
            return false;
        }
        return this.stateStatus == that.stateStatus;
    }

    public int hashCode() {
        int result = this.stateMachineInstanceId != null ? this.stateMachineInstanceId.hashCode() : 0;
        result = 31 * result + (this.stateId != null ? this.stateId.hashCode() : 0);
        result = 31 * result + this.retryAttempt;
        result = 31 * result + (this.stateStatus != null ? this.stateStatus.hashCode() : 0);
        result = 31 * result + (this.stateRollbackStatus != null ? this.stateRollbackStatus.hashCode() : 0);
        return result;
    }
}

