/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.examples;

import com.flipkart.flux.initializer.FluxInitializer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.yaml.snakeyaml.Yaml;

public class WorkflowExecutionDemo {
    public static void main(String[] args) {
        try {
            if (args.length < 2) {
                System.err.println("Usage: WorkflowExecutionDemo <module_name> <workflow_class_fqn>");
                System.exit(1);
            }
            String moduleName = args[0];
            String workflowClassFQN = args[1];
            String configFileName = "flux_config.yml";
            String mavenPath = args.length > 2 ? args[2] : "mvn";
            WorkflowExecutionDemo.runExample(moduleName, workflowClassFQN, configFileName, mavenPath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void runExample(String moduleName, String workflowClassFQN, String configFileName, String mavenPath) throws Exception {
        WorkflowExecutionDemo.executeCommand(mavenPath + " -pl " + moduleName + " -q package dependency:copy-dependencies -DincludeScope=runtime -DskipTests");
        FileReader reader = new FileReader(WorkflowExecutionDemo.class.getResource("/packaged/configuration.yml").getFile());
        String deploymentUnitsPath = (String)((Map)new Yaml().load((Reader)reader)).get("deploymentUnitsPath");
        if (!deploymentUnitsPath.endsWith("/")) {
            deploymentUnitsPath = deploymentUnitsPath + "/";
        }
        reader.close();
        String deploymentUnitName = "DU1/1";
        String mainDirPath = deploymentUnitsPath + deploymentUnitName + "/main";
        String libDirPath = deploymentUnitsPath + deploymentUnitName + "/lib";
        WorkflowExecutionDemo.executeCommand("mkdir -p " + mainDirPath);
        WorkflowExecutionDemo.executeCommand("mkdir -p " + libDirPath);
        FileUtils.copyFile((File)new File(moduleName + "/target/").listFiles((FilenameFilter)new WildcardFileFilter(moduleName + "*.jar"))[0], (File)new File(mainDirPath + "/" + moduleName + ".jar"));
        FileUtils.copyDirectory((File)new File(moduleName + "/target/dependency"), (File)new File(libDirPath));
        File mainResources = new File(moduleName + "/src/main/resources/" + configFileName);
        File testResources = new File(moduleName + "/src/test/resources/" + configFileName);
        if (mainResources.exists()) {
            FileUtils.copyFile((File)new File(moduleName + "/src/main/resources/" + configFileName), (File)new File(deploymentUnitsPath + deploymentUnitName + "/flux_config.yml"));
        } else if (testResources.exists()) {
            FileUtils.copyFile((File)new File(moduleName + "/src/test/resources/" + configFileName), (File)new File(deploymentUnitsPath + deploymentUnitName + "/flux_config.yml"));
        }
        FluxInitializer.main((String[])new String[0]);
        System.out.println("\u001b[34m" + WorkflowExecutionDemo.executeCommand("java -cp " + moduleName + "/target/*:" + moduleName + "/target/dependency/* " + workflowClassFQN) + '\u001b' + "[0m");
    }

    private static String executeCommand(String command) throws IOException, InterruptedException {
        StringBuilder output = new StringBuilder();
        Process p = Runtime.getRuntime().exec(command);
        p.waitFor();
        BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
        String line = "";
        while ((line = reader.readLine()) != null) {
            output.append(line).append("\n");
        }
        BufferedReader stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        String errorLine = "";
        while ((errorLine = stdError.readLine()) != null) {
            System.out.println(errorLine);
        }
        return output.toString();
    }
}

