/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.examples.decision;

import com.flipkart.flux.client.model.Task;
import com.flipkart.flux.client.model.Workflow;
import com.flipkart.flux.examples.decision.NotificationService;
import com.flipkart.flux.examples.decision.UserData;
import com.flipkart.flux.examples.decision.UserDataService;
import com.flipkart.flux.examples.decision.UserId;
import com.flipkart.flux.examples.decision.UserVerificationService;
import com.flipkart.flux.examples.decision.UserVerificationStatus;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class UserVerificationWorkflow {
    @Inject
    private UserVerificationService userVerificationService;
    @Inject
    private NotificationService notificationService;
    @Inject
    private UserDataService userDataService;

    @Workflow(version=1L)
    public void verifyUser(UserId userId) {
        UserData userData = this.userDataService.retrieveUserData(userId);
        UserVerificationStatus userVerificationStatus = this.userVerificationService.verifyUser(userData);
        this.checkVerificationStatus(userVerificationStatus);
    }

    @Task(version=1L, timeout=1000L, retries=2L)
    public void checkVerificationStatus(UserVerificationStatus userVerificationStatus) {
        if (userVerificationStatus.isVerifiedUser()) {
            this.notificationService.sendWelcomeEmail(userVerificationStatus.getUserId());
        } else {
            this.notificationService.notifyCustomerSupport(userVerificationStatus.getUserId());
        }
    }
}

