/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.examples.orderfulfilment;

import com.flipkart.flux.client.model.Promise;
import com.flipkart.flux.client.model.Task;
import com.flipkart.flux.client.model.Workflow;
import com.flipkart.flux.examples.orderfulfilment.ConfirmedOrder;
import com.flipkart.flux.examples.orderfulfilment.CreatedOrder;
import com.flipkart.flux.examples.orderfulfilment.OrderData;
import com.flipkart.flux.examples.orderfulfilment.OrderDeliveryInformation;
import com.flipkart.flux.examples.orderfulfilment.OrderManager;
import com.flipkart.flux.examples.orderfulfilment.PackedOrder;
import com.flipkart.flux.examples.orderfulfilment.PaymentService;
import com.flipkart.flux.examples.orderfulfilment.ShipmentService;
import com.flipkart.flux.examples.orderfulfilment.WarehouseService;

public class SimpleOrderFulfilmentWorkflow {
    OrderManager orderManager = new OrderManager();
    WarehouseService warehouseService = new WarehouseService();
    ShipmentService shipmentService = new ShipmentService();
    PaymentService paymentService = new PaymentService();

    @Workflow(version=1L)
    public void start(OrderData orderData) {
        Promise<CreatedOrder> createdOrder = this.orderManager.create(orderData);
        Promise<ConfirmedOrder> confirmedOrder = this.processPaymentIfRequired(createdOrder);
        Promise<PackedOrder> readyPackage = this.warehouseService.packOrder(confirmedOrder);
        Promise<OrderDeliveryInformation> orderDeliveryInformation = this.shipmentService.ship(readyPackage);
    }

    @Task(version=1L, timeout=1000L)
    public Promise<ConfirmedOrder> processPaymentIfRequired(Promise<CreatedOrder> createdOrderPromise) {
        CreatedOrder createdOrder = (CreatedOrder)createdOrderPromise.get();
        if (createdOrder.isCod()) {
            return this.orderManager.confirmOrder(createdOrderPromise, this.paymentService.processOnlinePayment(createdOrderPromise));
        }
        return this.orderManager.confirmOrder(createdOrder);
    }
}

