/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.utils;

import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.slf4j.MDC;

public class LoggingUtils {
    private static final Logger LOGGER = LogManager.getLogger(LoggingUtils.class);

    public static void registerStateMachineIdForLogging(String stateMachineId) {
        if (Objects.isNull(stateMachineId)) {
            LOGGER.warn("Cannot register for logging as stateMachineId is null");
            return;
        }
        MDC.put((String)"stateMachineId", (String)("smId:" + stateMachineId));
    }

    public static void deRegisterStateMachineIdForLogging() {
        try {
            MDC.remove((String)"stateMachineId");
        }
        catch (Exception ex) {
            LOGGER.error("MDC STATE_MACHINE_ID remove method have thrown exception with message {}", (Throwable)ex);
        }
    }
}

