/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.flux.api.EventDefinition;
import com.flipkart.flux.domain.Context;
import com.flipkart.flux.domain.State;
import com.flipkart.flux.domain.StateMachine;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Singleton
public class SearchUtil {
    private static ObjectMapper objectMapper = new ObjectMapper();

    public List<Long> findStatesInTraversalPath(Context context, StateMachine stateMachine, Long initialStateId) throws RuntimeException {
        ArrayList<Long> traversalPathStateIds = new ArrayList<Long>();
        Map<Long, Boolean> visitedStateIds = new HashMap<Long, Boolean>();
        HashMap<Long, String> stateOutputEvents = new HashMap<Long, String>();
        for (State state : stateMachine.getStates()) {
            try {
                stateOutputEvents.put(state.getId(), this.getOutputEventName(state.getOutputEvent()));
                visitedStateIds.put(state.getId(), Boolean.FALSE);
            }
            catch (IOException ex) {
                throw new RuntimeException("Error occurred while deserializing task outputEvent for stateMachineId: " + stateMachine.getId() + " stateId: " + state.getId());
            }
        }
        for (State state : stateMachine.getStates()) {
            if (((Boolean)visitedStateIds.get(state.getId())).booleanValue()) continue;
            if (initialStateId != state.getId()) {
                visitedStateIds = this.searchPaths(context, initialStateId, state.getId(), visitedStateIds, stateOutputEvents);
                continue;
            }
            visitedStateIds.put(state.getId(), Boolean.TRUE);
        }
        for (Map.Entry entry : visitedStateIds.entrySet()) {
            if (!((Boolean)entry.getValue()).booleanValue()) continue;
            traversalPathStateIds.add((Long)entry.getKey());
        }
        return traversalPathStateIds;
    }

    private Map<Long, Boolean> searchPaths(Context context, Long initialStateId, Long destinationStateId, Map<Long, Boolean> visitedStateIds, Map<Long, String> stateOutputEvents) {
        LinkedList queueOfPaths = new LinkedList();
        LinkedList currentPath = new LinkedList();
        currentPath.add(initialStateId);
        queueOfPaths.add(currentPath);
        while (queueOfPaths.size() != 0) {
            currentPath = (LinkedList)queueOfPaths.poll();
            Long lastStateId = (Long)currentPath.getLast();
            if (lastStateId.equals(destinationStateId)) {
                for (Long stateId : currentPath) {
                    visitedStateIds.put(stateId, Boolean.TRUE);
                }
                continue;
            }
            Set nextDependentStateIds = context.getDependentStateIds(stateOutputEvents.get(lastStateId));
            for (Long dependentStateId : nextDependentStateIds) {
                if (currentPath.contains(dependentStateId)) continue;
                LinkedList<Long> newPath = new LinkedList<Long>();
                newPath.addAll(currentPath);
                newPath.add(dependentStateId);
                queueOfPaths.add(newPath);
            }
        }
        return visitedStateIds;
    }

    private String getOutputEventName(String outputEvent) throws IOException {
        return outputEvent != null ? ((EventDefinition)objectMapper.readValue(outputEvent, EventDefinition.class)).getName() : null;
    }
}

