/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.persistence.impl;

import com.flipkart.flux.persistence.SessionFactoryContext;
import com.flipkart.flux.shard.ShardId;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

public class SessionFactoryContextImpl
implements SessionFactoryContext {
    private final ImmutableMap<ShardId, SessionFactory> RWSessionFactoryImmutableMap;
    private final ImmutableMap<ShardId, SessionFactory> ROSessionFactoryImmutableMap;
    private final ImmutableMap<String, ShardId> shardKeyToShardIdMap;
    private final SessionFactory schedulerSessionFactory;
    private final ThreadLocal<Session> currentSessionFactoryContext = new ThreadLocal();

    public SessionFactoryContextImpl(Map<ShardId, SessionFactory> rwSessionFactoryMap, Map<ShardId, SessionFactory> roSessionFactoryMap, Map<String, ShardId> shardKeyToShardIdMap, SessionFactory schedulerSessionFactory) {
        this.RWSessionFactoryImmutableMap = ImmutableMap.copyOf(rwSessionFactoryMap);
        this.ROSessionFactoryImmutableMap = ImmutableMap.copyOf(roSessionFactoryMap);
        this.shardKeyToShardIdMap = ImmutableMap.copyOf(shardKeyToShardIdMap);
        this.schedulerSessionFactory = schedulerSessionFactory;
    }

    @Override
    public void setThreadLocalSession(Session session) {
        this.currentSessionFactoryContext.set(session);
    }

    @Override
    public Session getThreadLocalSession() {
        return this.currentSessionFactoryContext.get();
    }

    @Override
    public SessionFactory getSchedulerSessionFactory() {
        return this.schedulerSessionFactory;
    }

    @Override
    public SessionFactory getRWSessionFactory(String shardKey) {
        return (SessionFactory)this.RWSessionFactoryImmutableMap.get(this.shardKeyToShardIdMap.get((Object)shardKey));
    }

    @Override
    public SessionFactory getROSessionFactory(ShardId shardId) {
        return (SessionFactory)this.ROSessionFactoryImmutableMap.get((Object)shardId);
    }

    @Override
    public void clear() {
        this.currentSessionFactoryContext.remove();
    }
}

