/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.persistence;

import java.security.MessageDigest;
import javax.xml.bind.DatatypeConverter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CryptHashGenerator {
    private static final String cryptHashAlgorithmPrefix = "SHA-256";
    private static final Logger logger = LogManager.getLogger(CryptHashGenerator.class);

    public static String getUniformCryptHash(String stateMachineId) {
        try {
            MessageDigest md = MessageDigest.getInstance(cryptHashAlgorithmPrefix);
            md.update(stateMachineId.getBytes());
            String cryptHash = DatatypeConverter.printHexBinary((byte[])md.digest()).toLowerCase();
            return cryptHash.substring(0, 2);
        }
        catch (Exception ex) {
            logger.error("Unable to generate Hash for the given stateMachine Id {} {}", (Object)stateMachineId, (Object)ex.getStackTrace());
            throw new RuntimeException("Exception in generating SHA-256 for the given key : " + stateMachineId);
        }
    }
}

