/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.guice.interceptor;

import com.flipkart.flux.persistence.CryptHashGenerator;
import com.flipkart.flux.persistence.SelectDataSource;
import com.flipkart.flux.persistence.SessionFactoryContext;
import com.flipkart.flux.shard.ShardId;
import com.flipkart.flux.shard.ShardedEntity;
import javax.inject.Provider;
import javax.persistence.PersistenceException;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;

public class TransactionInterceptor
implements MethodInterceptor {
    private static final Logger logger = LogManager.getLogger(TransactionInterceptor.class);
    private final Provider<SessionFactoryContext> contextProvider;

    public TransactionInterceptor(Provider<SessionFactoryContext> contextProvider) {
        this.contextProvider = contextProvider;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Transaction transaction = null;
        Session session = null;
        SessionFactoryContext context = (SessionFactoryContext)this.contextProvider.get();
        try {
            session = context.getThreadLocalSession();
        }
        catch (HibernateException hibernateException) {
            // empty catch block
        }
        if (session == null) {
            SessionFactory sessionFactory = null;
            try {
                SelectDataSource ds = invocation.getMethod().getAnnotation(SelectDataSource.class);
                block5 : switch (ds.storage()) {
                    case SHARDED: {
                        try {
                            switch (ds.type()) {
                                case READ_ONLY: {
                                    Object[] args = invocation.getArguments();
                                    ShardedEntity shardedEntity = this.getShardedEntity(args);
                                    if (shardedEntity != null) {
                                        if (shardedEntity.getShardId() != null) {
                                            sessionFactory = context.getROSessionFactory(shardedEntity.getShardId());
                                            break block5;
                                        }
                                        sessionFactory = context.getRWSessionFactory(CryptHashGenerator.getUniformCryptHash(shardedEntity.getShardKey()));
                                        break block5;
                                    }
                                    ShardId shardId = (ShardId)args[0];
                                    sessionFactory = context.getROSessionFactory(shardId);
                                    break block5;
                                }
                                case READ_WRITE: {
                                    Object[] args = invocation.getArguments();
                                    ShardedEntity shardedEntity = this.getShardedEntity(args);
                                    if (shardedEntity != null) {
                                        if (shardedEntity.getShardId() != null) {
                                            sessionFactory = context.getROSessionFactory(shardedEntity.getShardId());
                                            break block5;
                                        }
                                        sessionFactory = context.getRWSessionFactory(CryptHashGenerator.getUniformCryptHash(shardedEntity.getShardKey()));
                                        break block5;
                                    }
                                    String shardKey = (String)args[0];
                                    String shardKeyPrefix = CryptHashGenerator.getUniformCryptHash(shardKey);
                                    sessionFactory = context.getRWSessionFactory(shardKeyPrefix);
                                    break block5;
                                }
                            }
                            break;
                        }
                        catch (Exception ex) {
                            logger.error("Error reading Transactional Method with annotation @SelectDataSource Method_name:{} ", (Object)invocation.getMethod().getName(), (Object)ex);
                            return new PersistenceException("Something wrong with Method's annotations " + ex.getMessage(), (Throwable)ex);
                        }
                    }
                    case SCHEDULER: {
                        sessionFactory = context.getSchedulerSessionFactory();
                    }
                }
            }
            catch (Exception ex) {
                logger.error("Current Transactional Method doesn't have annotation @SelectDataSourceType Method_name:{} {}", (Object)invocation.getMethod().getName(), (Object)ex.getStackTrace());
                return new Error("Something wrong with Method's annotations " + ex.getMessage());
            }
            session = sessionFactory.openSession();
            context.setThreadLocalSession(session);
            logger.debug("Open new session for the thread transaction started, using it: {}, {}", (Object)invocation.getMethod().getName(), invocation.getMethod().getDeclaringClass());
            transaction = session.getTransaction();
            transaction.begin();
            try {
                Object result = invocation.proceed();
                transaction.commit();
                Object object = result;
                return object;
            }
            catch (Exception e) {
                if (transaction != null) {
                    transaction.rollback();
                }
                throw e;
            }
            finally {
                logger.debug("Transaction completed for method : {} {}", (Object)invocation.getMethod().getName(), invocation.getMethod().getDeclaringClass());
                if (session != null) {
                    session.close();
                }
                context.clear();
                logger.debug("Clearing session from ThreadLocal Context : {} {}", (Object)invocation.getMethod().getName(), invocation.getMethod().getDeclaringClass());
            }
        }
        Object result = invocation.proceed();
        logger.debug("Use old session for the thread, reusing it: {}, {}", (Object)invocation.getMethod().getName(), invocation.getMethod().getDeclaringClass());
        return result;
    }

    private ShardedEntity getShardedEntity(Object[] args) {
        for (Object arg : args) {
            ShardedEntity shardedEntity;
            if (arg == null) continue;
            if (ShardedEntity.class.isAssignableFrom(arg.getClass())) {
                return (ShardedEntity)arg;
            }
            if (!Object[].class.isAssignableFrom(arg.getClass()) || (shardedEntity = this.getShardedEntity((Object[])arg)) == null) continue;
            return shardedEntity;
        }
        return null;
    }
}

