/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.runner;

import com.flipkart.flux.guice.module.ConfigModule;
import com.flipkart.flux.runner.Modules;
import com.flipkart.polyguice.core.support.Polyguice;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;

public class GuiceJunit4Runner
extends BlockJUnit4ClassRunner {
    static final Map<Set<Class<? extends AbstractModule>>, Polyguice> polyguiceMap = new HashMap<Set<Class<? extends AbstractModule>>, Polyguice>();
    static final ConfigModule configModule = new ConfigModule();

    public GuiceJunit4Runner(Class<?> klass) throws InitializationError, IOException {
        super(klass);
    }

    protected Object createTest() throws Exception {
        Object testInstance = super.createTest();
        Polyguice polyInstance = this.getPolyInstance(testInstance);
        polyInstance.getComponentContext().inject(testInstance);
        return testInstance;
    }

    private Polyguice getPolyInstance(Object testInstance) {
        Modules moduleAnnotation = testInstance.getClass().getAnnotation(Modules.class);
        if (moduleAnnotation == null) {
            throw new RuntimeException("You now have to supply a @Modules annotation to use GuiceJunit4Runner");
        }
        Class<? extends AbstractModule>[] configuredModules = moduleAnnotation.value();
        HashSet moduleClassSet = new HashSet();
        Collections.addAll(moduleClassSet, configuredModules);
        if (!polyguiceMap.containsKey(moduleClassSet)) {
            AbstractModule[] createdModules = (AbstractModule[])moduleClassSet.stream().filter(aClass -> aClass != ConfigModule.class).map(new Function<Class<? extends AbstractModule>, AbstractModule>(){

                @Override
                public AbstractModule apply(Class<? extends AbstractModule> aClass) {
                    try {
                        return aClass.newInstance();
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        throw new RuntimeException(e);
                    }
                }
            }).toArray(value -> new AbstractModule[value + 1]);
            createdModules[createdModules.length - 1] = configModule;
            polyguiceMap.put(moduleClassSet, new Polyguice().modules((Module[])createdModules).registerConfigurationProvider(configModule.getConfigProvider()).prepare());
        }
        return polyguiceMap.get(moduleClassSet);
    }
}

