/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.interceptor;

import com.flipkart.flux.interceptor.InterceptedClass;
import com.flipkart.flux.interceptor.TestModule;
import com.flipkart.flux.persistence.DataSourceType;
import com.flipkart.flux.persistence.SessionFactoryContext;
import com.flipkart.flux.persistence.impl.SessionFactoryContextImpl;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.HashMap;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.junit.Test;
import org.mockito.Mockito;

public class TransactionInterceptorTest {
    @Test
    public void testTransactionInterceptorWithSessionFactoryContext() {
        SessionFactory readWriteSf = (SessionFactory)Mockito.mock(SessionFactory.class);
        SessionFactory readOnlySf = (SessionFactory)Mockito.mock(SessionFactory.class);
        this.prepareInteractions(readWriteSf);
        this.prepareInteractions(readOnlySf);
        HashMap<DataSourceType, SessionFactory> map = new HashMap<DataSourceType, SessionFactory>();
        map.put(DataSourceType.READ_WRITE, readWriteSf);
        map.put(DataSourceType.READ_ONLY, readOnlySf);
        SessionFactoryContextImpl context = new SessionFactoryContextImpl(map, DataSourceType.READ_WRITE);
        Injector injector = Guice.createInjector((Module[])new Module[]{new TestModule((SessionFactoryContext)context, readOnlySf)});
        InterceptedClass obj = (InterceptedClass)injector.getInstance(InterceptedClass.class);
        obj.readSome();
        obj.writeSome();
        obj.readSome();
        obj.writeSome();
    }

    private void prepareInteractions(SessionFactory sf) {
        Session mockedSession1 = (Session)Mockito.mock(Session.class);
        Transaction mockedTransaction1 = (Transaction)Mockito.mock(Transaction.class);
        Mockito.when((Object)sf.openSession()).thenReturn((Object)mockedSession1);
        Mockito.when((Object)sf.getCurrentSession()).thenReturn(null, (Object[])new Session[]{mockedSession1});
        Mockito.when((Object)mockedSession1.getTransaction()).thenReturn((Object)mockedTransaction1);
    }
}

