/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.guice.module;

import com.flipkart.polyguice.config.ApacheCommonsConfigProvider;
import com.flipkart.polyguice.config.YamlConfiguration;
import com.flipkart.polyguice.core.ConfigurationProvider;
import com.google.inject.AbstractModule;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.name.Names;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Iterator;

public class ConfigModule
extends AbstractModule {
    private final ConfigurationProvider configProvider;
    private final YamlConfiguration yamlConfiguration;

    public ConfigModule() {
        try {
            URL configUrl = null;
            String fluxConfigFile = System.getProperty("flux.configurationFile");
            configUrl = fluxConfigFile != null ? new File(fluxConfigFile).toURI().toURL() : ((Object)((Object)this)).getClass().getClassLoader().getResource("packaged/configuration.yml");
            this.configProvider = new ApacheCommonsConfigProvider().location(configUrl);
            this.yamlConfiguration = new YamlConfiguration(configUrl);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void configure() {
        this.bind(ConfigurationProvider.class).toInstance((Object)this.configProvider);
        this.bindConfigProperties();
    }

    private void bindConfigProperties() {
        this.bind(YamlConfiguration.class).toInstance((Object)this.yamlConfiguration);
        Iterator propertyKeys = this.yamlConfiguration.getKeys();
        while (propertyKeys.hasNext()) {
            String propertyKey = (String)propertyKeys.next();
            Object propertyValue = this.yamlConfiguration.getProperty(propertyKey);
            LinkedBindingBuilder annotatedWith = this.bind(propertyValue.getClass()).annotatedWith((Annotation)Names.named((String)propertyKey));
            annotatedWith.toInstance(propertyValue);
        }
    }

    public ConfigurationProvider getConfigProvider() {
        return this.configProvider;
    }
}

