/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.client.intercept;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.flux.api.EventData;
import com.flipkart.flux.api.EventDefinition;
import com.flipkart.flux.client.guice.annotation.IsolatedEnv;
import com.flipkart.flux.client.intercept.IllegalInvocationException;
import com.flipkart.flux.client.intercept.IllegalSignatureException;
import com.flipkart.flux.client.intercept.Intercepted;
import com.flipkart.flux.client.intercept.MethodId;
import com.flipkart.flux.client.intercept.ProxyEventCallbackFilter;
import com.flipkart.flux.client.intercept.ReturnGivenStringCallback;
import com.flipkart.flux.client.intercept.VersionMismatchException;
import com.flipkart.flux.client.model.Event;
import com.flipkart.flux.client.model.ExternalEvent;
import com.flipkart.flux.client.model.ReplayEvent;
import com.flipkart.flux.client.model.Task;
import com.flipkart.flux.client.registry.ExecutableImpl;
import com.flipkart.flux.client.registry.ExecutableRegistry;
import com.flipkart.flux.client.runtime.LocalContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Provider;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TaskInterceptor
implements MethodInterceptor {
    @Inject
    private LocalContext localContext;
    @Inject
    @IsolatedEnv
    private ExecutableRegistry executableRegistry;
    @Inject
    private Provider<ObjectMapper> objectMapperProvider;
    private static final Logger logger = LogManager.getLogger(TaskInterceptor.class);

    public TaskInterceptor() {
    }

    TaskInterceptor(LocalContext localContext, ExecutableRegistry executableRegistry, Provider<ObjectMapper> objectMapperProvider) {
        this.localContext = localContext;
        this.executableRegistry = executableRegistry;
        this.objectMapperProvider = objectMapperProvider;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        this.checkForBadSignatures(invocation);
        if (!this.localContext.isWorkflowInterception()) {
            return invocation.proceed();
        }
        Method method = invocation.getMethod();
        Task taskAnnotation = ((Task[])method.getAnnotationsByType(Task.class))[0];
        String taskIdentifier = this.generateTaskIdentifier(method, taskAnnotation);
        List<EventDefinition> dependencySet = this.generateDependencyList(invocation.getArguments(), method.getParameterAnnotations(), method.getParameterTypes());
        Object proxyReturnObject = this.createProxyReturnObject(method);
        EventDefinition outputEventDefintion = this.generateOutputEventDefintion(proxyReturnObject);
        if (this.localContext.getStateMachineDef() != null && this.localContext.getStateMachineDef().getVersion().longValue() != taskAnnotation.version()) {
            throw new VersionMismatchException("Mismatch between State machine and state versions for State: " + method.getDeclaringClass().getName() + "." + this.generateStateIdentifier(method) + ". StateMachine version: " + this.localContext.getStateMachineDef().getVersion() + ". State version: " + taskAnnotation.version());
        }
        if (taskAnnotation.isReplayable()) {
            this.localContext.registerNewState(taskAnnotation.version(), this.generateStateIdentifier(method), null, null, taskIdentifier, taskAnnotation.retries(), taskAnnotation.timeout(), taskAnnotation.isReplayable(), dependencySet, outputEventDefintion, taskAnnotation.replayRetries());
        } else {
            this.localContext.registerNewState(taskAnnotation.version(), this.generateStateIdentifier(method), null, null, taskIdentifier, taskAnnotation.retries(), taskAnnotation.timeout(), dependencySet, outputEventDefintion);
        }
        this.executableRegistry.registerTask(taskIdentifier, new ExecutableImpl(invocation.getThis(), invocation.getMethod(), taskAnnotation.timeout()));
        return proxyReturnObject;
    }

    private EventDefinition generateOutputEventDefintion(Object proxyReturnObject) {
        if (proxyReturnObject == null) {
            return null;
        }
        String eventName = ((Event)proxyReturnObject).name();
        String eventType = ((Intercepted)proxyReturnObject).getRealClassName();
        return new EventDefinition(eventName, eventType);
    }

    private Object createProxyReturnObject(final Method method) {
        if (method.getReturnType() == Void.TYPE) {
            return null;
        }
        String eventName = this.localContext.generateEventName(new Event(){

            @Override
            public String name() {
                return method.getReturnType().getName();
            }
        });
        final ReturnGivenStringCallback eventNameCallback = new ReturnGivenStringCallback(eventName);
        final ReturnGivenStringCallback realClassNameCallback = new ReturnGivenStringCallback(method.getReturnType().getName());
        ProxyEventCallbackFilter filter = new ProxyEventCallbackFilter(method.getReturnType(), new Class[]{Intercepted.class}){

            @Override
            protected ReturnGivenStringCallback getRealClassName() {
                return realClassNameCallback;
            }

            @Override
            public ReturnGivenStringCallback getNameCallback() {
                return eventNameCallback;
            }
        };
        return Enhancer.create(method.getReturnType(), (Class[])new Class[]{Intercepted.class}, (CallbackFilter)filter, (Callback[])filter.getCallbacks());
    }

    private void checkForBadSignatures(MethodInvocation invocation) {
        Class<?>[] parameterTypes;
        Method method = invocation.getMethod();
        for (Class<?> parameterType : parameterTypes = method.getParameterTypes()) {
            if (Event.class.isAssignableFrom(parameterType)) continue;
            throw new IllegalSignatureException(new MethodId(method), "Task parameters need to implement the com.flipkart.flux.client.model.Event interface. Found parameter of type" + parameterType + " which does not");
        }
    }

    private List<EventDefinition> generateDependencyList(Object[] arguments, Annotation[][] parameterAnnotations, Class<?>[] parameterTypes) throws JsonProcessingException, Exception {
        LinkedList<EventDefinition> eventDefinitions = new LinkedList<EventDefinition>();
        for (int i = 0; i < arguments.length; ++i) {
            Object argument = arguments[i];
            Object typeOfEvent = this.checkForEventAnnotation(parameterAnnotations[i]);
            if (typeOfEvent instanceof ExternalEvent) {
                if (argument != null) {
                    throw new IllegalInvocationException("cannot pass " + argument + " as the parameter is marked as external/replay event");
                }
                this.checkAndAddEventToEventDefinition(eventDefinitions, typeOfEvent, argument, parameterTypes, i);
                continue;
            }
            if (typeOfEvent instanceof ReplayEvent) {
                if (argument != null) {
                    throw new IllegalInvocationException("cannot pass " + argument + " as the parameter is marked as external/replay event");
                }
                this.checkAndAddEventToEventDefinition(eventDefinitions, typeOfEvent, argument, parameterTypes, i);
                continue;
            }
            if (argument instanceof Intercepted) {
                eventDefinitions.add(new EventDefinition(((Event)argument).name(), ((Intercepted)argument).getRealClassName()));
                continue;
            }
            String eventName = this.localContext.generateEventName((Event)argument);
            eventDefinitions.add(new EventDefinition(eventName, argument.getClass().getName()));
            this.localContext.addEvents(new EventData(eventName, argument.getClass().getName(), ((ObjectMapper)this.objectMapperProvider.get()).writeValueAsString(argument), "client"));
        }
        return eventDefinitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkAndAddEventToEventDefinition(List<EventDefinition> eventDefinitions, Object eventAnnotation, Object argument, Class<?>[] parameterTypes, int argumentIndex) throws Exception {
        EventDefinition definition = null;
        try {
            definition = new EventDefinition(((ExternalEvent)eventAnnotation).value(), parameterTypes[argumentIndex].getName());
            if (definition == null) return;
        }
        catch (ClassCastException e) {
            block10: {
                definition = new EventDefinition(((ReplayEvent)eventAnnotation).value(), parameterTypes[argumentIndex].getName(), "flux_runtime_replay_internal");
                if (definition == null) return;
                EventDefinition existingDefinition = this.localContext.checkExistingDefinition(definition);
                if (existingDefinition == null) break block10;
                eventDefinitions.add(existingDefinition);
                return;
            }
            eventDefinitions.add(definition);
            return;
        }
        catch (Exception e2) {
            block11: {
                logger.error(" Error while adding event to event definition" + e2.getMessage(), (Throwable)e2);
                if (definition == null) return;
                EventDefinition existingDefinition = this.localContext.checkExistingDefinition(definition);
                if (existingDefinition == null) break block11;
                eventDefinitions.add(existingDefinition);
                {
                    catch (Throwable throwable) {
                        if (definition == null) throw throwable;
                        EventDefinition existingDefinition2 = this.localContext.checkExistingDefinition(definition);
                        if (existingDefinition2 != null) {
                            eventDefinitions.add(existingDefinition2);
                            throw throwable;
                        } else {
                            eventDefinitions.add(definition);
                        }
                        throw throwable;
                    }
                }
                return;
            }
            eventDefinitions.add(definition);
            return;
        }
        EventDefinition existingDefinition = this.localContext.checkExistingDefinition(definition);
        if (existingDefinition != null) {
            eventDefinitions.add(existingDefinition);
            return;
        } else {
            eventDefinitions.add(definition);
        }
        return;
    }

    private <T> T checkForEventAnnotation(Annotation[] givenParameterAnnotations) {
        for (Annotation annotation : givenParameterAnnotations) {
            if (annotation instanceof ExternalEvent) {
                return (T)annotation;
            }
            if (!(annotation instanceof ReplayEvent)) continue;
            return (T)annotation;
        }
        return (T)Optional.empty();
    }

    private String generateStateIdentifier(Method method) {
        return method.getName();
    }

    private String generateTaskIdentifier(Method method, Task task) {
        return new MethodId(method).toString() + "_version" + task.version();
    }
}

