/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.client.runtime;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.flux.api.EventAndExecutionData;
import com.flipkart.flux.api.EventData;
import com.flipkart.flux.api.ExecutionUpdateData;
import com.flipkart.flux.api.StateMachineDefinition;
import com.flipkart.flux.client.runtime.FluxRuntimeConnector;
import com.flipkart.flux.client.runtime.RuntimeCommunicationException;
import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.ws.rs.core.Response;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FluxRuntimeConnectorHttpImpl
implements FluxRuntimeConnector {
    private static Logger logger = LoggerFactory.getLogger(FluxRuntimeConnectorHttpImpl.class);
    public static final int MAX_TOTAL = 200;
    public static final int MAX_PER_ROUTE = 20;
    public static final String EXTERNAL = "external";
    private final CloseableHttpClient closeableHttpClient;
    private final String fluxEndpoint;
    private final ObjectMapper objectMapper;

    @VisibleForTesting
    public FluxRuntimeConnectorHttpImpl(Long connectionTimeout, Long socketTimeout, String fluxEndpoint) {
        this(connectionTimeout, socketTimeout, fluxEndpoint, new ObjectMapper());
    }

    public FluxRuntimeConnectorHttpImpl(Long connectionTimeout, Long socketTimeout, String fluxEndpoint, ObjectMapper objectMapper) {
        this.fluxEndpoint = fluxEndpoint;
        this.objectMapper = objectMapper;
        RequestConfig clientConfig = RequestConfig.custom().setConnectTimeout(connectionTimeout.intValue()).setSocketTimeout(socketTimeout.intValue()).setConnectionRequestTimeout(socketTimeout.intValue()).build();
        PoolingHttpClientConnectionManager syncConnectionManager = new PoolingHttpClientConnectionManager();
        syncConnectionManager.setMaxTotal(200);
        syncConnectionManager.setDefaultMaxPerRoute(20);
        this.closeableHttpClient = HttpClientBuilder.create().setDefaultRequestConfig(clientConfig).setConnectionManager((HttpClientConnectionManager)syncConnectionManager).build();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> HttpClientUtils.closeQuietly((HttpClient)this.closeableHttpClient)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submitNewWorkflow(StateMachineDefinition stateMachineDef) {
        CloseableHttpResponse httpResponse;
        block4: {
            httpResponse = null;
            try {
                httpResponse = this.postOverHttp(stateMachineDef, "");
                if (!logger.isDebugEnabled()) break block4;
                try {
                    logger.debug("Flux returned response: {}", (Object)EntityUtils.toString((HttpEntity)httpResponse.getEntity()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly(httpResponse);
                throw throwable;
            }
        }
        HttpClientUtils.closeQuietly((CloseableHttpResponse)httpResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submitEventAndUpdateStatus(EventData eventData, Long stateMachineId, ExecutionUpdateData executionUpdateData) {
        CloseableHttpResponse httpResponse = null;
        try {
            EventAndExecutionData eventAndExecutionData = new EventAndExecutionData(eventData, executionUpdateData);
            httpResponse = this.postOverHttp(eventAndExecutionData, "/" + stateMachineId + "/context/eventandstatus");
        }
        catch (Throwable throwable) {
            HttpClientUtils.closeQuietly(httpResponse);
            throw throwable;
        }
        HttpClientUtils.closeQuietly((CloseableHttpResponse)httpResponse);
    }

    @Override
    public void submitEvent(String name, Object data, String correlationId, String eventSource) {
        String eventType = data.getClass().getName();
        if (eventSource == null) {
            eventSource = EXTERNAL;
        }
        CloseableHttpResponse httpResponse = null;
        try {
            EventData eventData = new EventData(name, eventType, this.objectMapper.writeValueAsString(data), eventSource);
            httpResponse = this.postOverHttp(eventData, "/" + correlationId + "/context/events?searchField=correlationId");
        }
        catch (JsonProcessingException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly(httpResponse);
                throw throwable;
            }
        }
        HttpClientUtils.closeQuietly((CloseableHttpResponse)httpResponse);
    }

    @Override
    public void submitScheduledEvent(String name, Object data, String correlationId, String eventSource, Long triggerTime) {
        CloseableHttpResponse httpResponse;
        block6: {
            String eventType = data.getClass().getName();
            if (eventSource == null) {
                eventSource = EXTERNAL;
            }
            httpResponse = null;
            try {
                if (triggerTime != null) {
                    EventData eventData = new EventData(name, eventType, this.objectMapper.writeValueAsString(data), eventSource);
                    httpResponse = this.postOverHttp(eventData, "/" + correlationId + "/context/events?searchField=correlationId&triggerTime=" + triggerTime);
                    break block6;
                }
                EventData eventData = new EventData(name, eventType, (String)data, eventSource);
                httpResponse = this.postOverHttp(eventData, "/" + correlationId + "/context/events?searchField=correlationId");
            }
            catch (JsonProcessingException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    HttpClientUtils.closeQuietly(httpResponse);
                    throw throwable;
                }
            }
        }
        HttpClientUtils.closeQuietly((CloseableHttpResponse)httpResponse);
    }

    @Override
    public void updateExecutionStatus(ExecutionUpdateData executionUpdateData) {
        CloseableHttpResponse httpResponse = null;
        httpResponse = this.postOverHttp(executionUpdateData, "/" + executionUpdateData.getStateMachineId() + "/" + executionUpdateData.getTaskId() + "/status");
        HttpClientUtils.closeQuietly((CloseableHttpResponse)httpResponse);
    }

    @Override
    public void incrementExecutionRetries(Long stateMachineId, Long taskId) {
        CloseableHttpResponse httpResponse = null;
        httpResponse = this.postOverHttp(null, "/" + stateMachineId + "/" + taskId + "/retries/inc");
        HttpClientUtils.closeQuietly((CloseableHttpResponse)httpResponse);
    }

    @Override
    public void redriveTask(Long taskId) {
        CloseableHttpResponse httpResponse = null;
        httpResponse = this.postOverHttp(null, "/redrivetask/" + taskId);
        HttpClientUtils.closeQuietly((CloseableHttpResponse)httpResponse);
    }

    private CloseableHttpResponse postOverHttp(Object dataToPost, String pathSuffix) {
        CloseableHttpResponse httpResponse = null;
        HttpPost httpPostRequest = new HttpPost(this.fluxEndpoint + pathSuffix);
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.objectMapper.writeValue((OutputStream)byteArrayOutputStream, dataToPost);
            httpPostRequest.setEntity((HttpEntity)new ByteArrayEntity(byteArrayOutputStream.toByteArray(), ContentType.APPLICATION_JSON));
            httpResponse = this.closeableHttpClient.execute((HttpUriRequest)httpPostRequest);
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode < Response.Status.OK.getStatusCode() || statusCode >= Response.Status.MOVED_PERMANENTLY.getStatusCode()) {
                logger.error("Did not receive a valid response from Flux core. Status code: {}, message: {}", (Object)statusCode, (Object)EntityUtils.toString((HttpEntity)httpResponse.getEntity()));
                HttpClientUtils.closeQuietly((CloseableHttpResponse)httpResponse);
                throw new RuntimeCommunicationException("Did not receive a valid response from Flux core");
            }
            logger.trace("Posting over http is successful. Status code: {}", (Object)statusCode);
        }
        catch (IOException e) {
            logger.error("Posting over http errored. Message: {}", (Object)e.getMessage(), (Object)e);
            HttpClientUtils.closeQuietly(httpResponse);
            throw new RuntimeCommunicationException("Could not communicate with Flux runtime: " + this.fluxEndpoint);
        }
        return httpResponse;
    }
}

