/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.client.runtime;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.flux.api.EventData;
import com.flipkart.flux.api.ExecutionUpdateData;
import com.flipkart.flux.api.StateMachineDefinition;
import com.flipkart.flux.client.runtime.FluxRuntimeConnector;
import com.flipkart.flux.client.runtime.RuntimeCommunicationException;
import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.ws.rs.core.Response;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;

public class FluxRuntimeConnectorHttpImpl
implements FluxRuntimeConnector {
    public static final int MAX_TOTAL = 200;
    public static final int MAX_PER_ROUTE = 20;
    public static final String EXTERNAL = "external";
    private final CloseableHttpClient closeableHttpClient;
    private final String fluxEndpoint;
    private final ObjectMapper objectMapper;

    @VisibleForTesting
    public FluxRuntimeConnectorHttpImpl(Long connectionTimeout, Long socketTimeout, String fluxEndpoint) {
        this(connectionTimeout, socketTimeout, fluxEndpoint, new ObjectMapper());
    }

    public FluxRuntimeConnectorHttpImpl(Long connectionTimeout, Long socketTimeout, String fluxEndpoint, ObjectMapper objectMapper) {
        this.fluxEndpoint = fluxEndpoint;
        this.objectMapper = objectMapper;
        RequestConfig clientConfig = RequestConfig.custom().setConnectTimeout(connectionTimeout.intValue()).setSocketTimeout(socketTimeout.intValue()).setConnectionRequestTimeout(socketTimeout.intValue()).build();
        PoolingHttpClientConnectionManager syncConnectionManager = new PoolingHttpClientConnectionManager();
        syncConnectionManager.setMaxTotal(200);
        syncConnectionManager.setDefaultMaxPerRoute(20);
        this.closeableHttpClient = HttpClientBuilder.create().setDefaultRequestConfig(clientConfig).setConnectionManager((HttpClientConnectionManager)syncConnectionManager).build();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> HttpClientUtils.closeQuietly((HttpClient)this.closeableHttpClient)));
    }

    @Override
    public void submitNewWorkflow(StateMachineDefinition stateMachineDef) {
        CloseableHttpResponse httpResponse = null;
        try {
            httpResponse = this.postOverHttp(stateMachineDef, "");
        }
        catch (Throwable throwable) {
            HttpClientUtils.closeQuietly(httpResponse);
            throw throwable;
        }
        HttpClientUtils.closeQuietly((CloseableHttpResponse)httpResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submitEvent(EventData eventData, Long stateMachineId) {
        CloseableHttpResponse httpResponse = null;
        try {
            httpResponse = this.postOverHttp(eventData, "/" + stateMachineId + "/context/events");
        }
        catch (Throwable throwable) {
            HttpClientUtils.closeQuietly(httpResponse);
            throw throwable;
        }
        HttpClientUtils.closeQuietly((CloseableHttpResponse)httpResponse);
    }

    @Override
    public void submitEvent(String name, Object data, String correlationId, String eventSource) {
        String eventType = data.getClass().getName();
        if (eventSource == null) {
            eventSource = EXTERNAL;
        }
        CloseableHttpResponse httpResponse = null;
        try {
            EventData eventData = new EventData(name, eventType, this.objectMapper.writeValueAsString(data), eventSource);
            httpResponse = this.postOverHttp(eventData, "/" + correlationId + "/context/events?searchField=correlationId");
        }
        catch (JsonProcessingException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly(httpResponse);
                throw throwable;
            }
        }
        HttpClientUtils.closeQuietly((CloseableHttpResponse)httpResponse);
    }

    @Override
    public void updateExecutionStatus(ExecutionUpdateData executionUpdateData) {
        CloseableHttpResponse httpResponse = null;
        httpResponse = this.postOverHttp(executionUpdateData, "/" + executionUpdateData.getStateMachineId() + "/" + executionUpdateData.getTaskId() + "/status");
        HttpClientUtils.closeQuietly((CloseableHttpResponse)httpResponse);
    }

    @Override
    public void incrementExecutionRetries(Long stateMachineId, Long taskId) {
        CloseableHttpResponse httpResponse = null;
        httpResponse = this.postOverHttp(null, "/" + stateMachineId + "/" + taskId + "/retries/inc");
        HttpClientUtils.closeQuietly((CloseableHttpResponse)httpResponse);
    }

    @Override
    public String getSerializedRedriverTaskByTaskId(Long taskId) throws IOException {
        CloseableHttpResponse httpResponse = null;
        httpResponse = this.getOverHttp("/redrivertask/" + taskId);
        String taskAndEventsJson = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
        HttpClientUtils.closeQuietly((CloseableHttpResponse)httpResponse);
        return taskAndEventsJson;
    }

    private CloseableHttpResponse postOverHttp(Object dataToPost, String pathSuffix) {
        CloseableHttpResponse httpResponse = null;
        HttpPost httpPostRequest = new HttpPost(this.fluxEndpoint + pathSuffix);
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.objectMapper.writeValue((OutputStream)byteArrayOutputStream, dataToPost);
            httpPostRequest.setEntity((HttpEntity)new ByteArrayEntity(byteArrayOutputStream.toByteArray(), ContentType.APPLICATION_JSON));
            httpResponse = this.closeableHttpClient.execute((HttpUriRequest)httpPostRequest);
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode < Response.Status.OK.getStatusCode() || statusCode >= Response.Status.MOVED_PERMANENTLY.getStatusCode()) {
                throw new RuntimeCommunicationException("Did not receive a valid response from Flux core");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeCommunicationException("Could not communicate with Flux runtime");
        }
        return httpResponse;
    }

    private CloseableHttpResponse getOverHttp(String pathSuffix) {
        CloseableHttpResponse httpResponse = null;
        HttpGet httpGet = new HttpGet(this.fluxEndpoint + pathSuffix);
        try {
            httpResponse = this.closeableHttpClient.execute((HttpUriRequest)httpGet);
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode < Response.Status.OK.getStatusCode() || statusCode >= Response.Status.MOVED_PERMANENTLY.getStatusCode()) {
                throw new RuntimeCommunicationException("Did not receive a valid response from Flux core while doing Http Get");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeCommunicationException("Could not communicate with Flux runtime");
        }
        return httpResponse;
    }
}

