/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.client.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.flux.api.EventData;
import com.flipkart.flux.api.StateMachineDefinition;
import com.flipkart.flux.client.runtime.FluxRuntimeConnector;
import com.flipkart.flux.client.runtime.RuntimeCommunicationException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.ws.rs.core.Response;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class FluxRuntimeConnectorHttpImpl
implements FluxRuntimeConnector {
    public static final int MAX_TOTAL = 200;
    public static final int MAX_PER_ROUTE = 20;
    private final CloseableHttpClient closeableHttpClient;
    private final String fluxEndpoint;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public FluxRuntimeConnectorHttpImpl(Long connectionTimeout, Long socketTimeout, String fluxEndpoint) {
        this.fluxEndpoint = fluxEndpoint;
        RequestConfig clientConfig = RequestConfig.custom().setConnectTimeout(connectionTimeout.intValue()).setSocketTimeout(socketTimeout.intValue()).setConnectionRequestTimeout(socketTimeout.intValue()).build();
        PoolingHttpClientConnectionManager syncConnectionManager = new PoolingHttpClientConnectionManager();
        syncConnectionManager.setMaxTotal(200);
        syncConnectionManager.setDefaultMaxPerRoute(20);
        this.closeableHttpClient = HttpClientBuilder.create().setDefaultRequestConfig(clientConfig).setConnectionManager((HttpClientConnectionManager)syncConnectionManager).build();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> HttpClientUtils.closeQuietly((HttpClient)this.closeableHttpClient)));
    }

    @Override
    public void submitNewWorkflow(StateMachineDefinition stateMachineDef) {
        CloseableHttpResponse httpResponse = null;
        try {
            httpResponse = this.postOverHttp(stateMachineDef, "");
        }
        catch (Throwable throwable) {
            HttpClientUtils.closeQuietly(httpResponse);
            throw throwable;
        }
        HttpClientUtils.closeQuietly((CloseableHttpResponse)httpResponse);
    }

    private CloseableHttpResponse postOverHttp(Object dataToPost, String pathSuffix) {
        CloseableHttpResponse httpResponse = null;
        HttpPost httpPostRequest = new HttpPost(String.valueOf(this.fluxEndpoint) + pathSuffix);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.objectMapper.writeValue((OutputStream)byteArrayOutputStream, dataToPost);
            httpPostRequest.setEntity((HttpEntity)new ByteArrayEntity(byteArrayOutputStream.toByteArray(), ContentType.APPLICATION_JSON));
            httpResponse = this.closeableHttpClient.execute((HttpUriRequest)httpPostRequest);
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode < Response.Status.OK.getStatusCode() || statusCode >= Response.Status.MOVED_PERMANENTLY.getStatusCode()) {
                throw new RuntimeCommunicationException("Did not receive a valid response from Flux core");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeCommunicationException("Could not communicate with Flux runtime");
        }
        return httpResponse;
    }

    @Override
    public void submitEvent(EventData eventData, Long stateMachineId) {
        CloseableHttpResponse httpResponse = null;
        try {
            httpResponse = this.postOverHttp(eventData, "/" + stateMachineId + "/context/events");
        }
        catch (Throwable throwable) {
            HttpClientUtils.closeQuietly(httpResponse);
            throw throwable;
        }
        HttpClientUtils.closeQuietly((CloseableHttpResponse)httpResponse);
    }
}

