/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.client.intercept;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.flux.api.EventData;
import com.flipkart.flux.client.intercept.IllegalSignatureException;
import com.flipkart.flux.client.intercept.MethodId;
import com.flipkart.flux.client.model.Event;
import com.flipkart.flux.client.model.Workflow;
import com.flipkart.flux.client.runtime.FluxRuntimeConnector;
import com.flipkart.flux.client.runtime.LocalContext;
import java.lang.reflect.Method;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

@Singleton
public class WorkflowInterceptor
implements MethodInterceptor {
    public static final String CLIENT = "client";
    @Inject
    private LocalContext localContext;
    @Inject
    private FluxRuntimeConnector connector;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public WorkflowInterceptor() {
    }

    public WorkflowInterceptor(LocalContext localContext, FluxRuntimeConnector connector) {
        this();
        this.localContext = localContext;
        this.connector = connector;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        try {
            Method method = invocation.getMethod();
            Workflow[] workFlowAnnotations = (Workflow[])method.getAnnotationsByType(Workflow.class);
            this.checkForBadSignatures(method);
            this.localContext.registerNew(new MethodId(method).toString(), workFlowAnnotations[0].version(), workFlowAnnotations[0].description());
            this.registerEventsForArguments(invocation.getArguments());
            invocation.proceed();
            this.connector.submitNewWorkflow(this.localContext.getStateMachineDef());
            return null;
        }
        finally {
            this.localContext.reset();
        }
    }

    private void registerEventsForArguments(Object[] arguments) throws JsonProcessingException {
        if (arguments.length == 0) {
            return;
        }
        EventData[] eventDatas = new EventData[arguments.length];
        int i = 0;
        while (i < arguments.length) {
            Object anArgument = arguments[i];
            Event anArgumentAsEvent = (Event)anArgument;
            String eventName = this.localContext.generateEventName(anArgumentAsEvent);
            eventDatas[i] = new EventData(eventName, anArgument.getClass().getName(), this.objectMapper.writeValueAsString(anArgument), CLIENT);
            ++i;
        }
        this.localContext.addEvents(eventDatas);
    }

    private void checkForBadSignatures(Method method) {
        Class<?> returnType = method.getReturnType();
        if (!returnType.equals(Void.TYPE)) {
            throw new IllegalSignatureException(new MethodId(method), "A workflow method can only return void");
        }
    }
}

