/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.fdp.irm.hadoop.yarn.facade;

import com.flipkart.fdp.irm.core.clients.IResourceClient;
import com.flipkart.fdp.irm.core.dao.IClusterDao;
import com.flipkart.fdp.irm.core.dao.IResourceDao;
import com.flipkart.fdp.irm.core.db.Resource;
import com.flipkart.fdp.irm.core.facade.CResourceFacade;
import com.flipkart.fdp.irm.core.validators.IQuotaIdValidator;
import com.flipkart.fdp.irm.exceptions.EBase;
import com.flipkart.fdp.irm.hadoop.yarn.clients.YarnResourceClientFactory;
import com.flipkart.fdp.irm.webentities.YarnQuotaWebEntity;
import com.flipkart.fdp.irm.webentities.YarnResourceUsage;
import com.google.inject.Inject;

public class CYarnResourceFacade
extends CResourceFacade {
    @Inject
    private YarnResourceClientFactory yarnResourceClientFactory;

    @Inject
    public CYarnResourceFacade(IResourceDao resourceDao, IClusterDao clusterDao, IQuotaIdValidator quotaIdValidator) {
        super(resourceDao, clusterDao, quotaIdValidator);
    }

    protected void actualResourceQuotaUpdate(Resource resource) throws EBase {
        IResourceClient<YarnQuotaWebEntity, YarnResourceUsage> yarnClient = this.yarnResourceClientFactory.create(resource.getCluster().getId());
        yarnClient.updateResourceQuota(resource);
    }

    protected String getToken(Resource resource) {
        return "-" + resource.getOrgName() + "-" + resource.getNamespaceName() + "-" + resource.getId();
    }

    protected void actualResourceCreation(Resource resource) throws EBase {
        IResourceClient<YarnQuotaWebEntity, YarnResourceUsage> yarnClient = this.yarnResourceClientFactory.create(resource.getCluster().getId());
        yarnClient.createResource(resource);
    }
}

