/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.fdp.irm.hadoop.yarn.facade;

import com.flipkart.fdp.irm.core.db.Cluster;
import com.flipkart.fdp.irm.core.facade.CClusterQuotaDetailsFacade;
import com.flipkart.fdp.irm.endpoints.HadoopClusterEndpoints;
import com.flipkart.fdp.irm.enums.ClusterType;
import com.flipkart.fdp.irm.exceptions.EBase;
import com.flipkart.fdp.irm.hadoop.yarn.clients.CYarnClusterClient;
import com.flipkart.fdp.irm.webentities.ClusterQuotaUsage;
import com.flipkart.fdp.irm.webentities.YarnClusterUsage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CYarnClusterQuotaDetailsFacade
extends CClusterQuotaDetailsFacade {
    private static final Logger log = LoggerFactory.getLogger(CYarnClusterQuotaDetailsFacade.class);

    public ClusterQuotaUsage getClusterQuota(Long clusterId) throws EBase {
        String rmUrl = this.getRmUrl(clusterId);
        CYarnClusterClient yarnClusterClient = new CYarnClusterClient(rmUrl);
        YarnClusterUsage yarnClusterUsage = yarnClusterClient.getClusterQuotaDetails();
        ClusterQuotaUsage clusterQuotaUsage = new ClusterQuotaUsage();
        clusterQuotaUsage.setClusterId(clusterId);
        clusterQuotaUsage.setClusterType(ClusterType.HADOOP);
        clusterQuotaUsage.setUsage((Object)yarnClusterUsage);
        log.debug("Cluster usage for {} for Yarn : {}", (Object)clusterId, (Object)clusterQuotaUsage);
        return clusterQuotaUsage;
    }

    private String getRmUrl(Long clusterId) throws EBase {
        HadoopClusterEndpoints hadoopClusterEndpoints = this.getHadoopClusterEndpoints(clusterId);
        return hadoopClusterEndpoints.getRmUrl();
    }

    private HadoopClusterEndpoints getHadoopClusterEndpoints(Long clusterId) throws EBase {
        Cluster cluster = (Cluster)this.clusterDao.getById(clusterId);
        return (HadoopClusterEndpoints)cluster.getEndpoints();
    }
}

