/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.fdp.irm.hadoop.yarn.clients;

import com.fasterxml.jackson.databind.JsonNode;
import com.flipkart.fdp.irm.core.clients.IResourceClient;
import com.flipkart.fdp.irm.core.dao.IClusterDao;
import com.flipkart.fdp.irm.core.dao.IQuotaReservationDao;
import com.flipkart.fdp.irm.core.dao.IResourceDao;
import com.flipkart.fdp.irm.core.db.QuotaReservation;
import com.flipkart.fdp.irm.core.db.Resource;
import com.flipkart.fdp.irm.enums.AccountType;
import com.flipkart.fdp.irm.enums.ResourceType;
import com.flipkart.fdp.irm.exceptions.EBase;
import com.flipkart.fdp.irm.exceptions.EFailure;
import com.flipkart.fdp.irm.exceptions.EInvalid;
import com.flipkart.fdp.irm.exceptions.ENotFound;
import com.flipkart.fdp.irm.hadoop.ambari.IAmbariConnector;
import com.flipkart.fdp.irm.hadoop.yarn.IFairSchedulerXmlGenerator;
import com.flipkart.fdp.irm.hadoop.yarn.IYarnHelper;
import com.flipkart.fdp.irm.hadoop.yarn.QueueDetails;
import com.flipkart.fdp.irm.hadoop.yarn.YarnResourceInfo;
import com.flipkart.fdp.irm.hadoop.yarn.clients.CYarnClusterClient;
import com.flipkart.fdp.irm.utils.CommonUtils;
import com.flipkart.fdp.irm.utils.RestConnector;
import com.flipkart.fdp.irm.webentities.YarnClusterUsage;
import com.flipkart.fdp.irm.webentities.YarnQuotaWebEntity;
import com.flipkart.fdp.irm.webentities.YarnResourceUsage;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.FairSchedulerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.FairSchedulerQueueInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ResourceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CYarnResourceClient
implements IResourceClient<YarnQuotaWebEntity, YarnResourceUsage> {
    private static final Logger log = LoggerFactory.getLogger(CYarnResourceClient.class);
    public static final String DEFAULT = "default";
    public static final String FDP_INFRA_ADMIN = "fdp-infra-admin";
    public static final long DEFAULT_QUEUE_MIN_MEMORY = 1024L;
    public static final long DEFAULT_QUEUE_MIN_CPU = 1L;
    private static final String SCHEDULER_URL = "ws/v1/cluster/scheduler";
    private IAmbariConnector ambariConnector;
    private String rmUrl;
    private RestConnector restConnector = new RestConnector();
    private Long clusterId;
    @Inject
    private IYarnHelper yarnHelper;
    @Inject
    private IResourceDao resourceDao;
    @Inject
    private IQuotaReservationDao quotaReservationDao;
    @Inject
    private IClusterDao clusterDao;
    @Inject
    private IFairSchedulerXmlGenerator fairSchedulerXmlGenerator;

    @Inject
    public CYarnResourceClient(IYarnHelper yarnHelper, IResourceDao resourceDao, IQuotaReservationDao quotaReservationDao, IClusterDao clusterDao, IFairSchedulerXmlGenerator fairSchedulerXmlGenerator, @Assisted Long clusterId) throws EBase {
        this.yarnHelper = yarnHelper;
        this.resourceDao = resourceDao;
        this.quotaReservationDao = quotaReservationDao;
        this.clusterDao = clusterDao;
        this.fairSchedulerXmlGenerator = fairSchedulerXmlGenerator;
        this.clusterId = clusterId;
        this.rmUrl = yarnHelper.getRmUrl(clusterId);
        this.ambariConnector = yarnHelper.getAmbariConnector(clusterId);
    }

    public void createResource(Resource resource) throws EBase {
        this.updateQueueConfigs(resource.getOrgName(), Optional.ofNullable(resource.getNamespaceName()), Optional.of(resource.getId()), (YarnQuotaWebEntity)resource.getQuota());
    }

    private void updateQueueConfigs(String orgName, Optional<String> namespaceName, Optional<Long> resourceId, YarnQuotaWebEntity yarnQuotaWebEntity) throws EBase {
        QueueDetails queueDetails = this.getQueueDetails(orgName, namespaceName, resourceId, yarnQuotaWebEntity);
        String xmlContent = this.fairSchedulerXmlGenerator.getFairSchedulerXml(queueDetails);
        String rmHosts = this.yarnHelper.getRmHosts(this.clusterId);
        this.ambariConnector.updateFairSchedulerConfig(xmlContent, rmHosts);
    }

    private QueueDetails getQueueDetails(String orgName, Optional<String> namespaceName, Optional<Long> resourceName, YarnQuotaWebEntity yarnQuota) throws EBase {
        QueueDetails queueDetails = new QueueDetails();
        queueDetails.setQueueName("root");
        queueDetails.setUserName(FDP_INFRA_ADMIN);
        CYarnClusterClient yarnClusterClient = new CYarnClusterClient(this.rmUrl);
        YarnClusterUsage yarnClusterUsage = yarnClusterClient.getClusterQuotaDetails();
        queueDetails.setMaxResources(new YarnResourceInfo(yarnClusterUsage.getMemoryTotalMB(), yarnClusterUsage.getCpuTotal()));
        queueDetails.setMinResources(new YarnResourceInfo(1024L, 1L));
        List<QueueDetails> orgQueues = this.getOrgQueues(orgName, namespaceName, resourceName, yarnQuota);
        String defaultQueueName = "root.default";
        String defaultUserName = FDP_INFRA_ADMIN;
        QueueDetails defaultQueueDetails = this.getDefaultQueueDetails(orgQueues, queueDetails.getMaxResources(), defaultQueueName, defaultUserName);
        orgQueues.add(defaultQueueDetails);
        queueDetails.setChildQueues(orgQueues);
        return queueDetails;
    }

    private List<QueueDetails> getOrgQueues(String orgName, Optional<String> namespaceName, Optional<Long> resourceId, YarnQuotaWebEntity yarnQuota) throws EBase {
        List<QuotaReservation> orgsOnCluster = this.getAllOrgsOnCluster(this.clusterId);
        ArrayList<QueueDetails> rootChildren = new ArrayList<QueueDetails>();
        for (QuotaReservation org : orgsOnCluster) {
            QueueDetails queueDetails = this.orgMatches(orgName, namespaceName, resourceId, org) ? this.getQueueDetailsFromQuota(yarnQuota, orgName, orgName) : this.getQueueDetailsForOrgOrNamespace(org);
            List<QueueDetails> namespaceQueues = this.getNamespaceQueues(this.clusterId, org.getOrgName(), orgName, namespaceName, resourceId, yarnQuota);
            String defaultQueueName = orgName + "-" + DEFAULT;
            String defaultUserName = orgName;
            QueueDetails defaultQueueDetails = this.getDefaultQueueDetails(namespaceQueues, queueDetails.getMaxResources(), defaultQueueName, defaultUserName);
            namespaceQueues.add(defaultQueueDetails);
            queueDetails.setChildQueues(namespaceQueues);
            rootChildren.add(queueDetails);
        }
        QueueDetails queueDetails = this.getQueueDetailsFromQuota(yarnQuota, orgName, orgName);
        String defaultQueueName = orgName + "-" + DEFAULT;
        String defaultUserName = orgName;
        QueueDetails defaultQueueDetails = this.getDefaultQueueDetails(Collections.emptyList(), queueDetails.getMaxResources(), defaultQueueName, defaultUserName);
        queueDetails.setChildQueues((List<QueueDetails>)ImmutableList.of((Object)defaultQueueDetails));
        rootChildren.add(queueDetails);
        return rootChildren;
    }

    private QueueDetails getDefaultQueueDetails(List<QueueDetails> orgQueues, YarnResourceInfo maxResources, String queueName, String userName) {
        YarnResourceInfo resourceInfo = maxResources;
        for (QueueDetails org : orgQueues) {
            resourceInfo.setMemory(maxResources.getMemory() - org.getMaxResources().getMemory());
            resourceInfo.setCpuCount(maxResources.getCpuCount() - org.getMaxResources().getCpuCount());
        }
        QueueDetails queueDetails = new QueueDetails();
        queueDetails.setMaxResources(resourceInfo);
        queueDetails.setMinResources(new YarnResourceInfo(1024L, 1L));
        queueDetails.setQueueName(queueName);
        queueDetails.setUserName(userName);
        queueDetails.setChildQueues(Collections.emptyList());
        return queueDetails;
    }

    List<QuotaReservation> getAllOrgsOnCluster(Long clusterId) throws EBase {
        return this.quotaReservationDao.getAllOrgsOnClusterOfResourceType(ResourceType.YARN, clusterId);
    }

    private boolean orgMatches(String orgName, Optional<String> namespaceName, Optional<Long> resourceId, QuotaReservation org) {
        return org.getOrgName().equals(orgName) && !namespaceName.isPresent() && !resourceId.isPresent();
    }

    private QueueDetails getQueueDetailsFromQuota(YarnQuotaWebEntity quotaToAdd, String queueName, String userName) {
        QueueDetails queueDetails = new QueueDetails();
        queueDetails.setQueueName(queueName);
        queueDetails.setUserName(userName);
        queueDetails.setMinResources(new YarnResourceInfo(quotaToAdd.getMinMemory(), quotaToAdd.getMinCpuCount()));
        queueDetails.setMaxResources(new YarnResourceInfo(quotaToAdd.getMaxMemory(), quotaToAdd.getMaxCpuCount()));
        queueDetails.setChildQueues(Collections.emptyList());
        return queueDetails;
    }

    private QueueDetails getQueueDetailsForOrgOrNamespace(QuotaReservation org) {
        String userName;
        String queueName;
        String orgNameToAdd = org.getOrgName();
        if (org.getAccountType() == AccountType.ORG) {
            queueName = orgNameToAdd;
            userName = orgNameToAdd;
        } else {
            userName = queueName = orgNameToAdd + "-" + org.getNamespaceName();
        }
        return this.getQueueDetailsFromQuota((YarnQuotaWebEntity)org.getQuota(), queueName, userName);
    }

    private List<QueueDetails> getNamespaceQueues(Long clusterId, String parentOrg, String orgName, Optional<String> namespaceName, Optional<Long> resourceId, YarnQuotaWebEntity yarnQuota) throws EBase {
        List<QuotaReservation> namespacesInOrg = this.reservationsInOrg(clusterId, parentOrg);
        ArrayList<QueueDetails> orgChildren = new ArrayList<QueueDetails>();
        for (QuotaReservation namespace : namespacesInOrg) {
            QueueDetails queueDetails = this.namespaceMatches(orgName, namespaceName, resourceId, namespace) ? this.getQueueDetailsForOrgOrNamespace(namespace) : this.getQueueDetailsForOrgOrNamespace(namespace);
            List<QueueDetails> resourceQueues = this.getResourceQueues(clusterId, namespace.getOrgName(), namespace.getNamespaceName(), orgName, namespaceName, resourceId, yarnQuota);
            String defaultQueueName = namespace.getOrgName() + "-" + namespace.getNamespaceName() + "-" + DEFAULT;
            String defaultUserName = orgName;
            QueueDetails defaultQueueDetails = this.getDefaultQueueDetails(resourceQueues, queueDetails.getMaxResources(), defaultQueueName, defaultUserName);
            resourceQueues.add(defaultQueueDetails);
            queueDetails.setChildQueues(resourceQueues);
            orgChildren.add(queueDetails);
        }
        return orgChildren;
    }

    List<QuotaReservation> reservationsInOrg(Long clusterId, String orgName) throws EBase {
        return this.quotaReservationDao.getAllNamespacesInsideOrgOnClusterOfResourceType(ResourceType.YARN, clusterId, orgName);
    }

    private boolean namespaceMatches(String orgName, Optional<String> namespaceName, Optional<Long> resourceName, QuotaReservation namespace) {
        return namespace.getOrgName().equals(orgName) && namespaceName.isPresent() && namespace.getNamespaceName().equals(namespaceName.get()) && !resourceName.isPresent();
    }

    private List<QueueDetails> getResourceQueues(Long clusterId, String parentOrgName, String parentNamespaceName, String orgName, Optional<String> namespaceName, Optional<Long> resourceId, YarnQuotaWebEntity yarnQuota) throws EBase {
        List<Resource> resourceList = this.getAllResourcesInClusterByOrgAndNamespace(clusterId, parentOrgName, parentNamespaceName);
        ArrayList<QueueDetails> namespaceChildren = new ArrayList<QueueDetails>();
        for (Resource resource : resourceList) {
            QueueDetails queueDetails = this.resourceMatches(parentOrgName, parentNamespaceName, orgName, namespaceName, resourceId, resource) ? this.getQueueDetailsForResource(resource) : this.getQueueDetailsForResource(resource);
            queueDetails.setChildQueues(Collections.emptyList());
            namespaceChildren.add(queueDetails);
        }
        return namespaceChildren;
    }

    private List<Resource> getAllResourcesInClusterByOrgAndNamespace(Long clusterId, String orgName, String namespaceName) throws EBase {
        return this.resourceDao.getResourcesOfTypeByOrgAndNamespaceOnCluster(ResourceType.YARN, clusterId, orgName, namespaceName);
    }

    private boolean resourceMatches(String parentOrgName, String parentNamespaceName, String orgName, Optional<String> namespaceName, Optional<Long> resourceId, Resource resource) {
        return parentOrgName.equals(orgName) && namespaceName.isPresent() && parentNamespaceName.equals(namespaceName.get()) && resourceId.isPresent() && resource.getId().equals(resourceId.get());
    }

    private QueueDetails getQueueDetailsForResource(Resource resource) {
        String queueName;
        String userName = queueName = resource.getOrgName() + "-" + resource.getNamespaceName() + "-" + resource.getId();
        return this.getQueueDetailsFromQuota((YarnQuotaWebEntity)resource.getQuota(), queueName, userName);
    }

    public YarnResourceUsage getUsage(Resource resource) throws EBase {
        String queueName = resource.getToken();
        return this.getYarnResourceUsage(resource.getCluster().getId(), queueName);
    }

    private YarnResourceUsage getYarnResourceUsage(Long clusterId, String queueName) throws EFailure, ENotFound {
        String getMetricsUrl = this.rmUrl.concat(SCHEDULER_URL);
        try {
            URI getMetricsUri = new URI(getMetricsUrl);
            String response = this.restConnector.hitGetURI(getMetricsUri, Optional.empty());
            log.debug("Response:  {}", (Object)response);
            FairSchedulerInfo fairSchedulerInfo = this.getFairSchedulerInfo(response);
            FairSchedulerQueueInfo queueInfo = this.getResourceQueueInfo(fairSchedulerInfo, queueName);
            return this.getYarnResourceUsage(clusterId, queueInfo);
        }
        catch (URISyntaxException e) {
            log.error("Exception while fetching yarn cluster scheduler metrics {}", (Object)e.getMessage());
            throw new EFailure((Exception)e);
        }
        catch (IOException e) {
            log.error("Exception while fetching queue usage information for queue : {}", (Object)queueName);
            throw new EFailure((Exception)e);
        }
    }

    public YarnResourceUsage getReservationUsage(QuotaReservation quotaReservation) throws URISyntaxException, EBase {
        String queueName = this.getQueueName(quotaReservation);
        return this.getYarnResourceUsage(quotaReservation.getCluster().getId(), queueName);
    }

    private String getQueueName(QuotaReservation quotaReservation) {
        String defaultQueueName = quotaReservation.getNamespaceName() != null ? quotaReservation.getOrgName() + "-" + quotaReservation.getNamespaceName() + "-" + DEFAULT : quotaReservation.getOrgName() + "-" + DEFAULT;
        return defaultQueueName;
    }

    private FairSchedulerInfo getFairSchedulerInfo(String response) throws IOException {
        JsonNode rootNode = (JsonNode)CommonUtils.OBJECT_MAPPER.readValue(response, JsonNode.class);
        JsonNode schedulerNode = (JsonNode)CommonUtils.OBJECT_MAPPER.readValue(rootNode.get("scheduler").toString(), JsonNode.class);
        return (FairSchedulerInfo)CommonUtils.OBJECT_MAPPER.readValue(schedulerNode.get("schedulerInfo").toString(), FairSchedulerInfo.class);
    }

    private FairSchedulerQueueInfo getResourceQueueInfo(FairSchedulerInfo fairSchedulerInfo, String queueName) throws ENotFound {
        String[] queueNameParts = queueName.split(".");
        String orgQueueName = queueNameParts[0];
        String namespaceQueueName = queueNameParts[0] + "." + queueNameParts[1];
        FairSchedulerQueueInfo rootQueueInfo = fairSchedulerInfo.getRootQueueInfo();
        Collection rootChildQueues = rootQueueInfo.getChildQueues();
        Collection<FairSchedulerQueueInfo> orgQueues = this.getChildQueuesInfo(orgQueueName, rootChildQueues);
        Collection<FairSchedulerQueueInfo> namespaceQueues = this.getChildQueuesInfo(namespaceQueueName, orgQueues);
        FairSchedulerQueueInfo resourceQueue = this.getListOfOrgOrNamespaceQueues(namespaceQueues, queueName);
        return resourceQueue;
    }

    private YarnResourceUsage getYarnResourceUsage(Long clusterId, FairSchedulerQueueInfo leafQueueInfo) {
        YarnResourceUsage yarnResourceUsage = new YarnResourceUsage();
        yarnResourceUsage.setQueueName(leafQueueInfo.getQueueName());
        yarnResourceUsage.setClusterId(clusterId);
        ResourceInfo totalResources = leafQueueInfo.getMaxResources();
        ResourceInfo usedResources = leafQueueInfo.getUsedResources();
        long totalCpu = totalResources.getvCores();
        long usedCpu = usedResources.getvCores();
        long totalMemory = totalResources.getMemory();
        long usedMemory = usedResources.getMemory();
        yarnResourceUsage.setCpuUsed(usedCpu);
        yarnResourceUsage.setCpuTotal(totalCpu);
        yarnResourceUsage.setMemoryTotal(totalMemory);
        yarnResourceUsage.setMemoryUsed(usedMemory);
        return yarnResourceUsage;
    }

    private Collection<FairSchedulerQueueInfo> getChildQueuesInfo(String orgQueueName, Collection<FairSchedulerQueueInfo> rootChildQueues) throws ENotFound {
        FairSchedulerQueueInfo orgQueue = this.getListOfOrgOrNamespaceQueues(rootChildQueues, orgQueueName);
        return orgQueue.getChildQueues();
    }

    private FairSchedulerQueueInfo getListOfOrgOrNamespaceQueues(Collection<FairSchedulerQueueInfo> queueInfos, String queueName) throws ENotFound {
        for (FairSchedulerQueueInfo queueInfo : queueInfos) {
            if (!queueInfo.getQueueName().equals(queueName)) continue;
            return queueInfo;
        }
        throw new ENotFound("Invalid Resource :  queue name not found.");
    }

    public void updateResourceQuota(Resource resource) throws EBase {
        this.updateQueueConfigs(resource.getOrgName(), Optional.of(resource.getNamespaceName()), Optional.of(resource.getId()), (YarnQuotaWebEntity)resource.getQuota());
    }

    public void reserveResourceQuota(QuotaReservation quotaReservation) throws EBase {
        this.updateQueueConfigs(quotaReservation.getOrgName(), Optional.ofNullable(quotaReservation.getNamespaceName()), Optional.empty(), (YarnQuotaWebEntity)quotaReservation.getQuota());
    }

    public void updateReservedQuota(QuotaReservation quotaReservation) throws EBase {
        this.updateQueueConfigs(quotaReservation.getOrgName(), Optional.ofNullable(quotaReservation.getNamespaceName()), Optional.empty(), (YarnQuotaWebEntity)quotaReservation.getQuota());
    }

    private YarnQuotaWebEntity getDefaultQueueQuota(YarnResourceInfo resourceInfo) throws EFailure, EInvalid {
        CYarnClusterClient yarnClusterClient = new CYarnClusterClient(this.rmUrl);
        YarnClusterUsage yarnClusterUsage = yarnClusterClient.getClusterQuotaDetails();
        long maxMemory = yarnClusterUsage.getMemoryTotalMB() - resourceInfo.getMemory();
        long maxCpuCount = yarnClusterUsage.getCpuTotal() - resourceInfo.getCpuCount();
        YarnQuotaWebEntity defaultQueueQuota = new YarnQuotaWebEntity(1024L, 1L, maxMemory, maxCpuCount);
        if (maxMemory <= 0L || maxCpuCount <= 0L) {
            log.error("Invalid configurations provided. Please contact FDP-Infra Admin.");
            throw new EInvalid("Invalid configurations provided. Please contact FDP-Infra Admin.");
        }
        return defaultQueueQuota;
    }

    List<Resource> getAllResourcesInCluster(Long clusterId) throws EBase {
        return this.resourceDao.getByResourceTypeOnCluster(ResourceType.YARN, clusterId);
    }

    public CYarnResourceClient() {
    }
}

