/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.fdp.irm.hadoop.hdfs.facade;

import com.flipkart.fdp.irm.core.dao.IClusterDao;
import com.flipkart.fdp.irm.core.dao.IResourceDao;
import com.flipkart.fdp.irm.core.db.Resource;
import com.flipkart.fdp.irm.core.facade.CResourceFacade;
import com.flipkart.fdp.irm.core.validators.IQuotaIdValidator;
import com.flipkart.fdp.irm.exceptions.EBase;
import com.flipkart.fdp.irm.hadoop.hdfs.IHdfsHelper;
import com.flipkart.fdp.irm.hadoop.hdfs.clients.CHdfsResourceClient;
import com.google.inject.Inject;

public class CHdfsResourceFacade
extends CResourceFacade {
    @Inject
    private IHdfsHelper hdfsHelper;

    @Inject
    public CHdfsResourceFacade(IResourceDao resourceDao, IClusterDao clusterDao, IQuotaIdValidator quotaIdValidator) {
        super(resourceDao, clusterDao, quotaIdValidator);
    }

    protected void actualResourceQuotaUpdate(Resource resource) throws EBase {
        String hdfsUri = this.hdfsHelper.getHdfsUri(resource.getCluster().getId());
        CHdfsResourceClient hdfsClient = new CHdfsResourceClient(hdfsUri);
        hdfsClient.updateResourceQuota(resource);
    }

    protected String getToken(Resource resource) {
        return "/" + resource.getOrgName() + "/" + resource.getNamespaceName() + "/" + resource.getId();
    }

    protected void actualResourceCreation(Resource resource) throws EBase {
        String hdfsUri = this.hdfsHelper.getHdfsUri(resource.getCluster().getId());
        CHdfsResourceClient hdfsClient = new CHdfsResourceClient(hdfsUri);
        hdfsClient.createResource(resource);
    }
}

