/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.fdp.irm.hadoop.hdfs.facade;

import com.flipkart.fdp.irm.core.db.QuotaReservation;
import com.flipkart.fdp.irm.core.db.Resource;
import com.flipkart.fdp.irm.core.facade.CQuotaUsageFacade;
import com.flipkart.fdp.irm.enums.ResourceType;
import com.flipkart.fdp.irm.exceptions.EBase;
import com.flipkart.fdp.irm.exceptions.EFailure;
import com.flipkart.fdp.irm.hadoop.hdfs.IHdfsHelper;
import com.flipkart.fdp.irm.hadoop.hdfs.clients.CHdfsResourceClient;
import com.flipkart.fdp.irm.webentities.HdfsResourceUsage;
import com.flipkart.fdp.irm.webentities.ResourceQuotaUsage;
import com.google.inject.Inject;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CHdfsQuotaUsageFacade
extends CQuotaUsageFacade {
    private static final Logger log = LoggerFactory.getLogger(CHdfsQuotaUsageFacade.class);
    @Inject
    private IHdfsHelper hdfsHelper;

    protected ResourceQuotaUsage getQuotaUsageOfResource(Resource resource) throws EBase {
        HdfsResourceUsage hdfsResourceUsage;
        String hdfsUri = this.hdfsHelper.getHdfsUri(resource.getCluster().getId());
        CHdfsResourceClient hdfsClient = new CHdfsResourceClient(hdfsUri);
        try {
            hdfsResourceUsage = (HdfsResourceUsage)hdfsClient.getUsage(resource);
        }
        catch (URISyntaxException e) {
            log.error("Exception while fetching hdfs usage.");
            throw new EFailure((Exception)e);
        }
        return this.getResourceQuotaUsage(hdfsResourceUsage);
    }

    protected ResourceQuotaUsage getQuotaUsageOfReservation(QuotaReservation quotaReservation) throws EBase {
        HdfsResourceUsage hdfsResourceUsage;
        String hdfsUri = this.hdfsHelper.getHdfsUri(quotaReservation.getCluster().getId());
        CHdfsResourceClient hdfsClient = new CHdfsResourceClient(hdfsUri);
        try {
            hdfsResourceUsage = (HdfsResourceUsage)hdfsClient.getReservationUsage(quotaReservation);
        }
        catch (URISyntaxException e) {
            log.error("Exception while fetching hdfs usage.");
            throw new EFailure((Exception)e);
        }
        return this.getResourceQuotaUsage(hdfsResourceUsage);
    }

    private ResourceQuotaUsage getResourceQuotaUsage(HdfsResourceUsage hdfsResourceUsage) {
        ResourceQuotaUsage resourceQuotaUsage = new ResourceQuotaUsage();
        resourceQuotaUsage.setResourceType(ResourceType.HDFS);
        resourceQuotaUsage.setUsage((Object)hdfsResourceUsage);
        return resourceQuotaUsage;
    }
}

