/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.fdp.irm.hadoop.yarn.facade;

import com.flipkart.fdp.irm.core.clients.IResourceClient;
import com.flipkart.fdp.irm.core.db.QuotaReservation;
import com.flipkart.fdp.irm.core.db.Resource;
import com.flipkart.fdp.irm.core.facade.CQuotaUsageFacade;
import com.flipkart.fdp.irm.enums.ResourceType;
import com.flipkart.fdp.irm.exceptions.EBase;
import com.flipkart.fdp.irm.exceptions.EFailure;
import com.flipkart.fdp.irm.hadoop.yarn.clients.YarnResourceClientFactory;
import com.flipkart.fdp.irm.webentities.ResourceQuotaUsage;
import com.flipkart.fdp.irm.webentities.YarnQuotaWebEntity;
import com.flipkart.fdp.irm.webentities.YarnResourceUsage;
import com.google.inject.Inject;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CYarnQuotaUsageFacade
extends CQuotaUsageFacade {
    private static final Logger log = LoggerFactory.getLogger(CYarnQuotaUsageFacade.class);
    @Inject
    private YarnResourceClientFactory yarnResourceClientFactory;

    protected ResourceQuotaUsage getQuotaUsageOfResource(Resource resource) throws EBase {
        YarnResourceUsage yarnResourceUsage;
        IResourceClient<YarnQuotaWebEntity, YarnResourceUsage> yarnClient = this.yarnResourceClientFactory.create(resource.getCluster().getId());
        try {
            yarnResourceUsage = (YarnResourceUsage)yarnClient.getUsage(resource);
        }
        catch (URISyntaxException e) {
            log.error("Exception while fetching yarn usage.");
            throw new EFailure((Exception)e);
        }
        return this.getResourceQuotaUsage(yarnResourceUsage);
    }

    protected ResourceQuotaUsage getQuotaUsageOfReservation(QuotaReservation quotaReservation) throws EBase {
        YarnResourceUsage yarnResourceUsage;
        IResourceClient<YarnQuotaWebEntity, YarnResourceUsage> yarnClient = this.yarnResourceClientFactory.create(quotaReservation.getCluster().getId());
        try {
            yarnResourceUsage = (YarnResourceUsage)yarnClient.getReservationUsage(quotaReservation);
        }
        catch (URISyntaxException e) {
            log.error("Exception while fetching yarn usage.");
            throw new EFailure((Exception)e);
        }
        return this.getResourceQuotaUsage(yarnResourceUsage);
    }

    private ResourceQuotaUsage getResourceQuotaUsage(YarnResourceUsage yarnResourceUsage) {
        ResourceQuotaUsage resourceQuotaUsage = new ResourceQuotaUsage();
        resourceQuotaUsage.setResourceType(ResourceType.YARN);
        resourceQuotaUsage.setUsage((Object)yarnResourceUsage);
        return resourceQuotaUsage;
    }
}

