/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.fdp.irm.hadoop.yarn;

import com.flipkart.fdp.irm.clusterManagers.AmbariClusterDetails;
import com.flipkart.fdp.irm.core.dao.IClusterDao;
import com.flipkart.fdp.irm.core.db.Cluster;
import com.flipkart.fdp.irm.endpoints.HadoopClusterEndpoints;
import com.flipkart.fdp.irm.exceptions.EBase;
import com.flipkart.fdp.irm.hadoop.ambari.CAmbariConnector;
import com.flipkart.fdp.irm.hadoop.ambari.IAmbariConnector;
import com.flipkart.fdp.irm.hadoop.yarn.IYarnHelper;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;

public class CYarnHelper
implements IYarnHelper {
    private IClusterDao clusterDao;

    @Inject
    public CYarnHelper(IClusterDao clusterDao) {
        this.clusterDao = clusterDao;
    }

    @Override
    public String getRmUrl(Long clusterId) throws EBase {
        HadoopClusterEndpoints hadoopClusterEndpoints = this.getHadoopClusterEndpoints(clusterId);
        return hadoopClusterEndpoints.getRmUrl();
    }

    @Override
    public String getRmHosts(Long clusterId) throws EBase {
        HadoopClusterEndpoints hadoopClusterEndpoints = this.getHadoopClusterEndpoints(clusterId);
        return hadoopClusterEndpoints.getRmHosts();
    }

    @Override
    public IAmbariConnector getAmbariConnector(Long clusterId) throws EBase {
        AmbariClusterDetails ambariClusterDetails = (AmbariClusterDetails)((Cluster)this.clusterDao.getById(clusterId)).getClusterManagerDetails();
        return new CAmbariConnector(ambariClusterDetails.getClusterName(), ambariClusterDetails.getBaseUrl(), ambariClusterDetails.getUser(), ambariClusterDetails.getPasswd());
    }

    private HadoopClusterEndpoints getHadoopClusterEndpoints(Long clusterId) throws EBase {
        Preconditions.checkNotNull((Object)this.clusterDao, (Object)"ClusterDao is not injected.");
        Cluster cluster = (Cluster)this.clusterDao.getById(clusterId);
        return (HadoopClusterEndpoints)cluster.getEndpoints();
    }

    public CYarnHelper() {
    }
}

