/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.fdp.irm.hadoop;

import com.flipkart.fdp.irm.exceptions.EFailure;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.client.HdfsAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopClusterHelper {
    private static final Logger log = LoggerFactory.getLogger(HadoopClusterHelper.class);
    private Configuration conf;

    public HadoopClusterHelper() {
        System.setProperty("HADOOP_USER_NAME", "hdfs");
        this.conf = new Configuration();
        this.conf.set("hadoop.job.ugi", "hdfs");
    }

    private void setHdfsUri(String hdfsUri) {
        this.conf.set("fs.default.name", hdfsUri);
    }

    public FileSystem getFileSystem(String hdfsUri) throws EFailure {
        try {
            URI uri = URI.create(hdfsUri);
            return FileSystem.get((URI)uri, (Configuration)this.conf);
        }
        catch (IOException e) {
            log.error("Exception while getting FS object of HDFS Cluster. {} , {}", (Object)hdfsUri, (Object)e.getMessage());
            throw new EFailure((Exception)e);
        }
    }

    public HdfsAdmin getHdfsAdmin(String hdfsUri) throws EFailure {
        URI uri = URI.create(hdfsUri);
        try {
            return new HdfsAdmin(uri, this.conf);
        }
        catch (IOException e) {
            log.error("Exception while getting HdfsAdmin object of HDFS Cluster. {} , {}", (Object)hdfsUri, (Object)e.getMessage());
            throw new EFailure((Exception)e);
        }
    }
}

