/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.fdp.irm.clients;

import com.flipkart.fdp.irm.enums.ResourceType;
import com.flipkart.fdp.irm.exceptions.EFailure;
import com.flipkart.fdp.irm.utils.CommonUtils;
import com.flipkart.fdp.irm.utils.RestConnector;
import com.flipkart.fdp.irm.webentities.QuotaReservationWebEntity;
import com.flipkart.fdp.irm.webentities.QuotaWebEntity;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;

public abstract class QuotaReservationBase {
    private String baseUrl;
    private RestConnector restConnector = new RestConnector();

    public QuotaReservationBase(String username, String password, String baseUrl) {
        this.restConnector.setAuthEncoding(username, password);
        this.baseUrl = baseUrl;
    }

    protected QuotaReservationWebEntity reserveQuota(QuotaReservationWebEntity quotaReservationWebEntity) throws EFailure {
        try {
            URI uri = new URI(this.baseUrl + String.format("/quota/reservation/resourceType/%s", quotaReservationWebEntity.getResourceType().toString()));
            String result = this.restConnector.hitPostURI(uri, quotaReservationWebEntity.toString(), Optional.empty());
            return (QuotaReservationWebEntity)CommonUtils.OBJECT_MAPPER.readValue(result, QuotaReservationWebEntity.class);
        }
        catch (IOException | URISyntaxException e) {
            throw new EFailure(e);
        }
    }

    protected QuotaReservationWebEntity updateReserveQuota(Long quotaReservationId, QuotaWebEntity quotaWebEntity, ResourceType resourceType) throws EFailure {
        try {
            URI uri = new URI(this.baseUrl + String.format("/quota/reservation/resourceType/%s/%s/resourceQuota/%s", resourceType.toString(), quotaReservationId, quotaWebEntity));
            String result = this.restConnector.hitPutURI(uri, Optional.empty(), Optional.empty());
            return (QuotaReservationWebEntity)CommonUtils.OBJECT_MAPPER.readValue(result, QuotaReservationWebEntity.class);
        }
        catch (IOException | URISyntaxException e) {
            throw new EFailure(e);
        }
    }
}

