/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.fdp.irm.clients;

import com.flipkart.fdp.irm.enums.ResourceType;
import com.flipkart.fdp.irm.exceptions.EBase;
import com.flipkart.fdp.irm.exceptions.EFailure;
import com.flipkart.fdp.irm.utils.CommonUtils;
import com.flipkart.fdp.irm.utils.RestConnector;
import com.flipkart.fdp.irm.webentities.QuotaWebEntity;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;

public class CQuotaManagement {
    private String baseUrl;
    private RestConnector restConnector = new RestConnector();

    public CQuotaManagement(String username, String password, String baseUrl) {
        this.restConnector.setAuthEncoding(username, password);
        this.baseUrl = baseUrl;
    }

    public <E extends QuotaWebEntity> E getQuotaEntityDetails(ResourceType resourceType, String quotaId) throws EBase {
        try {
            URI uri = new URI(this.baseUrl + String.format("/quota/%s/%s", resourceType.toString(), quotaId));
            String result = this.restConnector.hitGetURI(uri, Optional.empty());
            return (E)((QuotaWebEntity)CommonUtils.OBJECT_MAPPER.readValue(result, resourceType.getQuotaEntityClass()));
        }
        catch (IOException | URISyntaxException e) {
            throw new EFailure(e);
        }
    }

    public <E extends QuotaWebEntity> E updateQuotaEntityDetails(ResourceType resourceType, String quotaId, Class<? extends QuotaWebEntity> quotaEntity) throws EBase {
        try {
            URI uri = new URI(this.baseUrl + String.format("/quota/%s/%s", resourceType.toString(), quotaId));
            String result = this.restConnector.hitPutURI(uri, Optional.of(quotaEntity.toString()), Optional.empty());
            return (E)((QuotaWebEntity)CommonUtils.OBJECT_MAPPER.readValue(result, resourceType.getQuotaEntityClass()));
        }
        catch (IOException | URISyntaxException e) {
            throw new EFailure(e);
        }
    }

    public <E extends QuotaWebEntity> E createQuotaEntity(ResourceType resourceType, Class<? extends QuotaWebEntity> quotaEntity) throws EBase {
        try {
            URI uri = new URI(this.baseUrl + String.format("/quota/%s", resourceType.toString()));
            String result = this.restConnector.hitPostURI(uri, quotaEntity.toString(), Optional.empty());
            return (E)((QuotaWebEntity)CommonUtils.OBJECT_MAPPER.readValue(result, resourceType.getQuotaEntityClass()));
        }
        catch (IOException | URISyntaxException e) {
            throw new EFailure(e);
        }
    }
}

