/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.fdp.irm.clients;

import com.fasterxml.jackson.core.type.TypeReference;
import com.flipkart.fdp.irm.clients.IIrmReadClient;
import com.flipkart.fdp.irm.enums.ClusterType;
import com.flipkart.fdp.irm.enums.ResourceType;
import com.flipkart.fdp.irm.exceptions.EBase;
import com.flipkart.fdp.irm.exceptions.EFailure;
import com.flipkart.fdp.irm.utils.CommonUtils;
import com.flipkart.fdp.irm.utils.RestConnector;
import com.flipkart.fdp.irm.webentities.ClusterQuotaUsage;
import com.flipkart.fdp.irm.webentities.ClusterWebEntity;
import com.flipkart.fdp.irm.webentities.QuotaReservationWebEntity;
import com.flipkart.fdp.irm.webentities.ResourceWebEntity;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class CIrmReadClient
implements IIrmReadClient {
    private String baseUrl;
    private RestConnector restConnector = new RestConnector();

    public CIrmReadClient(String username, String password, String baseUrl) {
        this.restConnector.setAuthEncoding(username, password);
        this.baseUrl = baseUrl;
    }

    @Override
    public ClusterWebEntity getClusterDetails(Long clusterId) throws EBase {
        try {
            URI uri = new URI(this.baseUrl + String.format("/cluster/%s", clusterId));
            String result = this.restConnector.hitGetURI(uri, Optional.empty());
            return (ClusterWebEntity)CommonUtils.OBJECT_MAPPER.readValue(result, ClusterWebEntity.class);
        }
        catch (IOException | URISyntaxException e) {
            throw new EFailure(e);
        }
    }

    @Override
    public List<ClusterWebEntity> getAllClusters() throws EBase {
        try {
            URI uri = new URI(this.baseUrl + "/cluster");
            return this.getClusterWebEntities(uri);
        }
        catch (URISyntaxException e) {
            throw new EFailure((Exception)e);
        }
    }

    @Override
    public List<ClusterWebEntity> getAllClusterInZone(Long zoneId) throws EBase {
        try {
            URI uri = new URI(this.baseUrl + String.format("/cluster/zone/%s", zoneId));
            return this.getClusterWebEntities(uri);
        }
        catch (URISyntaxException e) {
            throw new EFailure((Exception)e);
        }
    }

    @Override
    public List<ClusterWebEntity> getAllClustersOfClusterType(ClusterType clusterType) throws EBase {
        try {
            URI uri = new URI(this.baseUrl + String.format("/cluster/clusterType/%s", clusterType));
            return this.getClusterWebEntities(uri);
        }
        catch (URISyntaxException e) {
            throw new EFailure((Exception)e);
        }
    }

    @Override
    public List<ClusterWebEntity> getAllClustersOfResourceType(ResourceType resourceType) throws EBase {
        try {
            URI uri = new URI(this.baseUrl + String.format("/cluster/resourceType/%s", resourceType));
            return this.getClusterWebEntities(uri);
        }
        catch (URISyntaxException e) {
            throw new EFailure((Exception)e);
        }
    }

    @Override
    public List<ResourceType> getAllResourceTypes() throws EBase {
        try {
            URI uri = new URI(this.baseUrl + "/resourceType");
            return this.getResourceTypes(uri);
        }
        catch (URISyntaxException e) {
            throw new EFailure((Exception)e);
        }
    }

    private List<ResourceType> getResourceTypes(URI uri) throws EFailure {
        String result = this.restConnector.hitGetURI(uri, Optional.empty());
        try {
            return (List)CommonUtils.OBJECT_MAPPER.readValue(result, (TypeReference)new TypeReference<List<ResourceType>>(){});
        }
        catch (IOException e) {
            throw new EFailure((Exception)e);
        }
    }

    @Override
    public List<ResourceType> getResourceTypesOnCluster(ClusterType clusterType) throws EBase {
        try {
            URI uri = new URI(this.baseUrl + String.format("/resourceType/clusterType/%s", clusterType));
            return this.getResourceTypes(uri);
        }
        catch (URISyntaxException e) {
            throw new EFailure((Exception)e);
        }
    }

    @Override
    public ResourceWebEntity getResourceDetails(Long resourceId) throws EBase {
        try {
            URI uri = new URI(this.baseUrl + String.format("/resource/%s", resourceId));
            String result = this.restConnector.hitGetURI(uri, Optional.empty());
            return (ResourceWebEntity)CommonUtils.OBJECT_MAPPER.readValue(result, ResourceWebEntity.class);
        }
        catch (IOException | URISyntaxException e) {
            throw new EFailure(e);
        }
    }

    @Override
    public List<ResourceWebEntity> getAllResources() throws EBase {
        try {
            URI uri = new URI(this.baseUrl + "/resource");
            return this.getResourceWebEntities(uri);
        }
        catch (URISyntaxException e) {
            throw new EFailure((Exception)e);
        }
    }

    @Override
    public List<ResourceWebEntity> getAllResourcesOfType(ResourceType resourceType) throws EBase {
        try {
            URI uri = new URI(this.baseUrl + String.format("/resource/resourceType/%s", resourceType));
            return this.getResourceWebEntities(uri);
        }
        catch (URISyntaxException e) {
            throw new EFailure((Exception)e);
        }
    }

    @Override
    public List<ResourceWebEntity> getResourcesOfTypeOnCluster(ResourceType resourceType, Long clusterId) throws EBase {
        try {
            URI uri = new URI(this.baseUrl + String.format("/resource/resourceType/%s/cluster/%s", resourceType, clusterId));
            return this.getResourceWebEntities(uri);
        }
        catch (URISyntaxException e) {
            throw new EFailure((Exception)e);
        }
    }

    @Override
    public List<ResourceWebEntity> getResourcesByOrg(String orgName) throws EBase {
        try {
            URI uri = new URI(this.baseUrl + String.format("/resource/org/%s", orgName));
            return this.getResourceWebEntities(uri);
        }
        catch (URISyntaxException e) {
            throw new EFailure((Exception)e);
        }
    }

    @Override
    public List<ResourceWebEntity> getResourcesByOrgAndNamespace(String orgName, String namespaceName) throws EBase {
        try {
            URI uri = new URI(this.baseUrl + String.format("/resource/org/%s/namespace/%s", orgName, namespaceName));
            return this.getResourceWebEntities(uri);
        }
        catch (URISyntaxException e) {
            throw new EFailure((Exception)e);
        }
    }

    @Override
    public Map<String, String> getResourceEndpoints(String resourceName) throws EBase {
        try {
            URI uri = new URI(this.baseUrl + String.format("/resource/endpoints/%s", resourceName));
            String result = this.restConnector.hitGetURI(uri, Optional.empty());
            return (Map)CommonUtils.OBJECT_MAPPER.readValue(result, (TypeReference)new TypeReference<Map<String, String>>(){});
        }
        catch (IOException | URISyntaxException e) {
            throw new EFailure(e);
        }
    }

    @Override
    public List<ClusterQuotaUsage> getClusterUsageDetails(ClusterType clusterType, Long clusterId) throws EBase {
        try {
            URI uri = new URI(this.baseUrl + String.format("/quota_details/cluster/%s/clusterType/%s", clusterId, clusterType));
            String result = this.restConnector.hitGetURI(uri, Optional.empty());
            return (List)CommonUtils.OBJECT_MAPPER.readValue(result, (TypeReference)new TypeReference<List<ClusterQuotaUsage>>(){});
        }
        catch (IOException | URISyntaxException e) {
            throw new EFailure(e);
        }
    }

    @Override
    public List<QuotaReservationWebEntity> getQuotaReservationsOnClusterByResourceType(Long clusterId, ResourceType resourceType) throws EBase {
        try {
            URI uri = new URI(this.baseUrl + String.format("/quota/reservation/resourceType/%s/cluster/%s", resourceType.toString(), clusterId));
            return this.getQuotaReservationWebEntities(uri);
        }
        catch (IOException | URISyntaxException e) {
            throw new EFailure(e);
        }
    }

    private List<QuotaReservationWebEntity> getQuotaReservationWebEntities(URI uri) throws EFailure, IOException {
        String result = this.restConnector.hitGetURI(uri, Optional.empty());
        return (List)CommonUtils.OBJECT_MAPPER.readValue(result, (TypeReference)new TypeReference<List<QuotaReservationWebEntity>>(){});
    }

    @Override
    public List<QuotaReservationWebEntity> getQuotaReservationsForNamespace(ResourceType resourceType, String orgName, String namespaceName) throws EBase {
        try {
            URI uri = new URI(this.baseUrl + String.format("/quota/reservation/resourceType/%s/org/%s/namespace/%s", resourceType.toString(), orgName, namespaceName));
            return this.getQuotaReservationWebEntities(uri);
        }
        catch (IOException | URISyntaxException e) {
            throw new EFailure(e);
        }
    }

    @Override
    public List<QuotaReservationWebEntity> getQuotaReservationsForOrgByResourceType(String orgName, ResourceType resourceType) throws EBase {
        try {
            URI uri = new URI(this.baseUrl + String.format("/quota/reservation/resourceType/%s/org/%s", resourceType.toString(), orgName));
            return this.getQuotaReservationWebEntities(uri);
        }
        catch (IOException | URISyntaxException e) {
            throw new EFailure(e);
        }
    }

    @Override
    public List<QuotaReservationWebEntity> getQuotaReservationsByResourceType(ResourceType resourceType) throws EBase {
        try {
            URI uri = new URI(this.baseUrl + String.format("/quota/reservation/resourceType/%s", resourceType.toString()));
            return this.getQuotaReservationWebEntities(uri);
        }
        catch (IOException | URISyntaxException e) {
            throw new EFailure(e);
        }
    }

    @Override
    public QuotaReservationWebEntity getQuotaReservationsOfOrgByResourceTypeAndClusterName(ResourceType resourceType, Long clusterId, String orgName) throws EBase {
        try {
            URI uri = new URI(this.baseUrl + String.format("/quota/reservation/resourceType/%s/cluster/%s/org/%s", resourceType.toString(), clusterId, orgName));
            String result = this.restConnector.hitGetURI(uri, Optional.empty());
            return (QuotaReservationWebEntity)CommonUtils.OBJECT_MAPPER.readValue(result, QuotaReservationWebEntity.class);
        }
        catch (IOException | URISyntaxException e) {
            throw new EFailure(e);
        }
    }

    @Override
    public QuotaReservationWebEntity getQuotaReservationsOfNamespaceByResourceTypeAndClusterName(ResourceType resourceType, Long clusterId, String orgName, String namespaceName) throws EBase {
        try {
            URI uri = new URI(this.baseUrl + String.format("/quota/reservation/resourceType/%s/cluster/%s/org/%s/namespace/%s", resourceType.toString(), clusterId, orgName, namespaceName));
            String result = this.restConnector.hitGetURI(uri, Optional.empty());
            return (QuotaReservationWebEntity)CommonUtils.OBJECT_MAPPER.readValue(result, QuotaReservationWebEntity.class);
        }
        catch (IOException | URISyntaxException e) {
            throw new EFailure(e);
        }
    }

    private List<ResourceWebEntity> getResourceWebEntities(URI uri) throws EFailure {
        String result = this.restConnector.hitGetURI(uri, Optional.empty());
        try {
            return (List)CommonUtils.OBJECT_MAPPER.readValue(result, (TypeReference)new TypeReference<List<ResourceWebEntity>>(){});
        }
        catch (IOException e) {
            throw new EFailure((Exception)e);
        }
    }

    private List<ClusterWebEntity> getClusterWebEntities(URI uri) throws EFailure {
        String result = this.restConnector.hitGetURI(uri, Optional.empty());
        try {
            return (List)CommonUtils.OBJECT_MAPPER.readValue(result, (TypeReference)new TypeReference<List<ClusterWebEntity>>(){});
        }
        catch (IOException e) {
            throw new EFailure((Exception)e);
        }
    }
}

