/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.fdp.irm.clients;

import com.flipkart.fdp.irm.clients.CIrmReadClient;
import com.flipkart.fdp.irm.clients.CQuotaManagement;
import com.flipkart.fdp.irm.clients.IIrmOrgAdminWriteClient;
import com.flipkart.fdp.irm.clients.QuotaReservationBase;
import com.flipkart.fdp.irm.enums.AccountType;
import com.flipkart.fdp.irm.enums.ResourceType;
import com.flipkart.fdp.irm.exceptions.EBase;
import com.flipkart.fdp.irm.webentities.QuotaReservationWebEntity;
import com.flipkart.fdp.irm.webentities.QuotaWebEntity;

public class CIrmOrgAdminWriteClient
extends QuotaReservationBase
implements IIrmOrgAdminWriteClient {
    private CIrmReadClient readClient;
    private CQuotaManagement cQuotaManagement;

    public CIrmOrgAdminWriteClient(String username, String password, String baseUrl) {
        super(username, password, baseUrl);
        this.cQuotaManagement = new CQuotaManagement(username, password, baseUrl);
        this.readClient = new CIrmReadClient(username, password, baseUrl);
    }

    @Override
    public QuotaReservationWebEntity reserveQuotaForNamespace(String orgName, String namespaceName, Long clusterId, ResourceType resourceType, QuotaWebEntity quotaWebEntity) throws EBase {
        QuotaReservationWebEntity quotaReservationWebEntity = new QuotaReservationWebEntity(resourceType, AccountType.ORG, clusterId, quotaWebEntity, orgName);
        quotaReservationWebEntity.setNamespaceName(namespaceName);
        return this.reserveQuota(quotaReservationWebEntity);
    }

    @Override
    public QuotaReservationWebEntity updateReservedQuotaOfNamespace(String orgName, String namespaceName, Long clusterId, ResourceType resourceType, QuotaWebEntity quotaWebEntity) throws EBase {
        QuotaReservationWebEntity quotaReservationWebEntity = this.readClient.getQuotaReservationsOfNamespaceByResourceTypeAndClusterName(resourceType, clusterId, orgName, namespaceName);
        return this.updateReserveQuota(quotaReservationWebEntity.getId(), quotaWebEntity, resourceType);
    }
}

