/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.fdp.irm.clients;

import com.flipkart.fdp.irm.clients.CQuotaManagement;
import com.flipkart.fdp.irm.clients.IIrmNamespaceAdminWriteClient;
import com.flipkart.fdp.irm.enums.ResourceType;
import com.flipkart.fdp.irm.exceptions.EBase;
import com.flipkart.fdp.irm.exceptions.EFailure;
import com.flipkart.fdp.irm.exceptions.ENotYetImplemented;
import com.flipkart.fdp.irm.utils.CommonUtils;
import com.flipkart.fdp.irm.utils.RestConnector;
import com.flipkart.fdp.irm.webentities.QuotaWebEntity;
import com.flipkart.fdp.irm.webentities.ResourceWebEntity;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;

public class CIrmNamespaceAdminWriteClient
implements IIrmNamespaceAdminWriteClient {
    private String baseUrl;
    private RestConnector restConnector = new RestConnector();
    private CQuotaManagement cQuotaManagement;

    public CIrmNamespaceAdminWriteClient(String username, String password, String baseUrl) {
        this.restConnector.setAuthEncoding(username, password);
        this.baseUrl = baseUrl;
        this.cQuotaManagement = new CQuotaManagement(username, password, baseUrl);
    }

    @Override
    public ResourceWebEntity createResource(ResourceWebEntity resourceWebEntity, QuotaWebEntity quotaWebEntity) throws EBase {
        ResourceType resourceType = resourceWebEntity.getResourceType();
        return this.saveResource(resourceWebEntity, quotaWebEntity);
    }

    private ResourceWebEntity saveResource(ResourceWebEntity resourceWebEntity, QuotaWebEntity quotaWebEntity) throws EFailure {
        resourceWebEntity.setQuota(quotaWebEntity);
        try {
            URI uri = new URI(this.baseUrl + "/resource");
            String result = this.restConnector.hitPostURI(uri, resourceWebEntity.toString(), Optional.empty());
            return (ResourceWebEntity)CommonUtils.OBJECT_MAPPER.readValue(result, ResourceWebEntity.class);
        }
        catch (IOException | URISyntaxException e) {
            throw new EFailure(e);
        }
    }

    @Override
    public ResourceWebEntity updateResourceDetails(Long resourceId, ResourceWebEntity resourceWebEntity) throws EBase {
        try {
            URI uri = new URI(this.baseUrl + String.format("/resource/%s", resourceId));
            String result = this.restConnector.hitPutURI(uri, Optional.of(resourceWebEntity.toString()), Optional.empty());
            return (ResourceWebEntity)CommonUtils.OBJECT_MAPPER.readValue(result, ResourceWebEntity.class);
        }
        catch (IOException | URISyntaxException e) {
            throw new EFailure(e);
        }
    }

    @Override
    public ResourceWebEntity deleteResource(Long resourceId) throws EBase {
        throw new ENotYetImplemented();
    }

    @Override
    public ResourceWebEntity updateResourceAllocation(Long resourceId, ResourceType resourceType, QuotaWebEntity quotaWebEntity) throws EBase {
        return this.updateAllocation(resourceId, quotaWebEntity);
    }

    private ResourceWebEntity updateAllocation(Long resourceId, QuotaWebEntity quotaWebEntity) throws EBase {
        try {
            URI uri = new URI(this.baseUrl + String.format("/resource/%s/resourceQuota/%s", resourceId, quotaWebEntity));
            String result = this.restConnector.hitPutURI(uri, Optional.empty(), Optional.empty());
            return (ResourceWebEntity)CommonUtils.OBJECT_MAPPER.readValue(result, ResourceWebEntity.class);
        }
        catch (IOException | URISyntaxException e) {
            throw new EFailure(e);
        }
    }
}

