/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.fdp.irm.clients;

import com.fasterxml.jackson.core.type.TypeReference;
import com.flipkart.fdp.irm.clients.IIrmInfraAdminWriteClient;
import com.flipkart.fdp.irm.endpoints.ClusterEndpoints;
import com.flipkart.fdp.irm.exceptions.EBase;
import com.flipkart.fdp.irm.exceptions.EFailure;
import com.flipkart.fdp.irm.exceptions.ENotYetImplemented;
import com.flipkart.fdp.irm.utils.CommonUtils;
import com.flipkart.fdp.irm.utils.RestConnector;
import com.flipkart.fdp.irm.webentities.AmbariClusterDetailsWebEntity;
import com.flipkart.fdp.irm.webentities.ClusterWebEntity;
import com.flipkart.fdp.irm.webentities.RegionWebEntity;
import com.flipkart.fdp.irm.webentities.ZoneWebEntity;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CIrmInfraAdminWriteClient
implements IIrmInfraAdminWriteClient {
    private static final Logger log = LoggerFactory.getLogger(CIrmInfraAdminWriteClient.class);
    private String baseUrl;
    private RestConnector restConnector = new RestConnector();

    public CIrmInfraAdminWriteClient(String username, String password, String baseUrl) {
        this.restConnector.setAuthEncoding(username, password);
        this.baseUrl = baseUrl;
    }

    @Override
    public ClusterWebEntity createClusterDetails(ClusterWebEntity clusterWebEntity) throws EBase {
        try {
            URI uri = new URI(this.baseUrl + "/cluster");
            String result = this.restConnector.hitPostURI(uri, clusterWebEntity.toString(), Optional.empty());
            return (ClusterWebEntity)CommonUtils.OBJECT_MAPPER.readValue(result, ClusterWebEntity.class);
        }
        catch (IOException | URISyntaxException e) {
            throw new EFailure(e);
        }
    }

    @Override
    public ClusterWebEntity updateClusterDetails(ClusterWebEntity cluster) throws EBase {
        try {
            URI uri = new URI(this.baseUrl + "/cluster/%s");
            String result = this.restConnector.hitPutURI(uri, Optional.of(cluster.toString()), Optional.empty());
            return (ClusterWebEntity)CommonUtils.OBJECT_MAPPER.readValue(result, ClusterWebEntity.class);
        }
        catch (IOException | URISyntaxException e) {
            throw new EFailure(e);
        }
    }

    @Override
    public ClusterWebEntity updateAmbariClusterDetails(Long clusterId, AmbariClusterDetailsWebEntity ambariClusterDetailsWebEntity) throws EBase {
        try {
            URI uri = new URI(this.baseUrl + String.format("/cluster/%s/clusterManagerDetails", clusterId));
            String result = this.restConnector.hitPutURI(uri, Optional.of(ambariClusterDetailsWebEntity.toString()), Optional.empty());
            return (ClusterWebEntity)CommonUtils.OBJECT_MAPPER.readValue(result, ClusterWebEntity.class);
        }
        catch (IOException | URISyntaxException e) {
            throw new EFailure(e);
        }
    }

    @Override
    public ClusterWebEntity updateClusterEndpointsDetails(Long clusterId, Class<? extends ClusterEndpoints> clusterEndpoints) throws EBase {
        try {
            URI uri = new URI(this.baseUrl + String.format("/cluster/%s/endpoints", clusterId));
            String result = this.restConnector.hitPutURI(uri, Optional.of(clusterEndpoints.toString()), Optional.empty());
            return (ClusterWebEntity)CommonUtils.OBJECT_MAPPER.readValue(result, ClusterWebEntity.class);
        }
        catch (IOException | URISyntaxException e) {
            throw new EFailure(e);
        }
    }

    @Override
    public ZoneWebEntity createZone(ZoneWebEntity zoneWebEntity) throws EBase {
        try {
            URI uri = new URI(this.baseUrl + "/zone");
            String result = this.restConnector.hitPostURI(uri, zoneWebEntity.toString(), Optional.empty());
            return (ZoneWebEntity)CommonUtils.OBJECT_MAPPER.readValue(result, ZoneWebEntity.class);
        }
        catch (IOException | URISyntaxException e) {
            throw new EFailure(e);
        }
    }

    @Override
    public ZoneWebEntity updateZone(Long zoneId, ZoneWebEntity zoneWebEntity) throws EBase {
        try {
            URI uri = new URI(this.baseUrl + String.format("/zone/%s", zoneId));
            String result = this.restConnector.hitPostURI(uri, zoneWebEntity.toString(), Optional.empty());
            return (ZoneWebEntity)CommonUtils.OBJECT_MAPPER.readValue(result, ZoneWebEntity.class);
        }
        catch (IOException | URISyntaxException e) {
            throw new EFailure(e);
        }
    }

    @Override
    public ZoneWebEntity deleteZone(Long zoneId) throws EBase {
        throw new ENotYetImplemented();
    }

    @Override
    public ZoneWebEntity getZoneDetails(Long zoneId) throws EBase {
        try {
            URI uri = new URI(this.baseUrl + String.format("/zone/%s", zoneId));
            String result = this.restConnector.hitGetURI(uri, Optional.empty());
            return (ZoneWebEntity)CommonUtils.OBJECT_MAPPER.readValue(result, ZoneWebEntity.class);
        }
        catch (IOException | URISyntaxException e) {
            throw new EFailure(e);
        }
    }

    @Override
    public List<ZoneWebEntity> getAllZones() throws EBase {
        try {
            URI uri = new URI(this.baseUrl + "/zone");
            String result = this.restConnector.hitGetURI(uri, Optional.empty());
            return (List)CommonUtils.OBJECT_MAPPER.readValue(result, (TypeReference)new TypeReference<List<RegionWebEntity>>(){});
        }
        catch (IOException | URISyntaxException e) {
            throw new EFailure(e);
        }
    }

    @Override
    public List<ZoneWebEntity> getAllZonesInRegion(Long regionId) throws EBase {
        try {
            URI uri = new URI(this.baseUrl + String.format("/zone/region/%s", regionId));
            String result = this.restConnector.hitGetURI(uri, Optional.empty());
            return (List)CommonUtils.OBJECT_MAPPER.readValue(result, (TypeReference)new TypeReference<List<RegionWebEntity>>(){});
        }
        catch (IOException | URISyntaxException e) {
            throw new EFailure(e);
        }
    }

    @Override
    public RegionWebEntity createRegion(RegionWebEntity regionWebEntity) throws EBase {
        try {
            URI uri = new URI(this.baseUrl + "/region");
            String result = this.restConnector.hitPostURI(uri, regionWebEntity.toString(), Optional.empty());
            return (RegionWebEntity)CommonUtils.OBJECT_MAPPER.readValue(result, RegionWebEntity.class);
        }
        catch (IOException | URISyntaxException e) {
            throw new EFailure(e);
        }
    }

    @Override
    public RegionWebEntity updateRegion(Long regionId, RegionWebEntity regionWebEntity) throws EBase {
        try {
            URI uri = new URI(this.baseUrl + String.format("/region/%s", regionId));
            String result = this.restConnector.hitPutURI(uri, Optional.of(regionWebEntity.toString()), Optional.empty());
            return (RegionWebEntity)CommonUtils.OBJECT_MAPPER.readValue(result, RegionWebEntity.class);
        }
        catch (IOException | URISyntaxException e) {
            throw new EFailure(e);
        }
    }

    @Override
    public RegionWebEntity deleteRegion(Long regionId) throws EBase {
        throw new ENotYetImplemented();
    }

    @Override
    public RegionWebEntity getRegionDetails(Long regionId) throws EBase {
        try {
            URI uri = new URI(this.baseUrl + String.format("/region/%s", regionId));
            String result = this.restConnector.hitGetURI(uri, Optional.empty());
            return (RegionWebEntity)CommonUtils.OBJECT_MAPPER.readValue(result, RegionWebEntity.class);
        }
        catch (IOException | URISyntaxException e) {
            throw new EFailure(e);
        }
    }

    @Override
    public List<RegionWebEntity> getAllRegions() throws EBase {
        try {
            URI uri = new URI(this.baseUrl + "/region");
            String result = this.restConnector.hitGetURI(uri, Optional.empty());
            return (List)CommonUtils.OBJECT_MAPPER.readValue(result, (TypeReference)new TypeReference<List<RegionWebEntity>>(){});
        }
        catch (IOException | URISyntaxException e) {
            throw new EFailure(e);
        }
    }
}

