/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.fdp.irm.clients;

import com.flipkart.fdp.irm.clients.CIrmReadClient;
import com.flipkart.fdp.irm.clients.CQuotaManagement;
import com.flipkart.fdp.irm.clients.IIrmFdpAdminWriteClient;
import com.flipkart.fdp.irm.clients.QuotaReservationBase;
import com.flipkart.fdp.irm.enums.AccountType;
import com.flipkart.fdp.irm.enums.ResourceType;
import com.flipkart.fdp.irm.exceptions.EBase;
import com.flipkart.fdp.irm.webentities.QuotaReservationWebEntity;
import com.flipkart.fdp.irm.webentities.QuotaWebEntity;

public class CIrmFdpAdminWriteWriteClient
extends QuotaReservationBase
implements IIrmFdpAdminWriteClient {
    private CIrmReadClient readClient;
    private CQuotaManagement cQuotaManagement;

    public CIrmFdpAdminWriteWriteClient(String username, String password, String baseUrl) {
        super(username, password, baseUrl);
        this.cQuotaManagement = new CQuotaManagement(username, password, baseUrl);
        this.readClient = new CIrmReadClient(username, password, baseUrl);
    }

    @Override
    public QuotaReservationWebEntity reserveQuotaForOrg(String orgName, Long clusterId, ResourceType resourceType, QuotaWebEntity quotaWebEntity) throws EBase {
        QuotaReservationWebEntity quotaReservationWebEntity = new QuotaReservationWebEntity(resourceType, AccountType.ORG, clusterId, quotaWebEntity, orgName);
        return this.reserveQuota(quotaReservationWebEntity);
    }

    @Override
    public QuotaReservationWebEntity updateReservedQuotaOfOrg(String orgName, Long clusterId, ResourceType resourceType, QuotaWebEntity quotaWebEntity) throws EBase {
        QuotaReservationWebEntity quotaReservationWebEntity = this.readClient.getQuotaReservationsOfOrgByResourceTypeAndClusterName(resourceType, clusterId, orgName);
        return this.updateReserveQuota(quotaReservationWebEntity.getId(), quotaWebEntity, resourceType);
    }
}

