/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.drift.commons.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ObjectMapperUtil {
    INSTANCE;

    private static final Logger log;
    private final ObjectMapper objectMapper = new ObjectMapper();

    private ObjectMapperUtil() {
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public ObjectMapper getMapper() {
        return this.objectMapper;
    }

    public <T> T getObj(String s, Class<T> clazz) throws IOException {
        return (T)this.getMapper().readValue(s, clazz);
    }

    public <T> T getObj(JsonNode j, Class<T> clazz) throws IOException {
        return (T)this.getMapper().treeToValue((TreeNode)j, clazz);
    }

    public JsonNode getJsonNode(Object obj) {
        return (JsonNode)this.getMapper().convertValue(obj, JsonNode.class);
    }

    public ObjectNode getObjectNode(Object obj) {
        return (ObjectNode)this.getMapper().convertValue(obj, ObjectNode.class);
    }

    public String toJson(Object object) {
        try {
            return this.objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            log.error("Exception while writing value as string {}", (Object)e.getMessage());
            return null;
        }
    }

    public <T> T fromJson(String json, TypeReference<T> typeRef) {
        try {
            return (T)this.objectMapper.readValue(json, typeRef);
        }
        catch (Exception e) {
            log.error("Exception while converting value {} to {}. Error: {}", new Object[]{json, typeRef, e.getMessage()});
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(ObjectMapperUtil.class);
    }
}

