/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.drift.commons.utils;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum MetricsRegistry {
    INSTANCE;

    private static final Logger log;
    private static final String SEPARATOR = ".";
    private final MetricRegistry metricRegistry = new MetricRegistry();

    private MetricsRegistry() {
        JmxReporter jmxReporter = JmxReporter.forRegistry((MetricRegistry)this.metricRegistry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
        jmxReporter.start();
    }

    public static <T extends Metric> T registerGauge(Class<?> callerClass, T metric, String ... names) {
        String metricName = MetricRegistry.name(callerClass, (String[])names);
        try {
            return (T)INSTANCE.getRegistry().register(metricName, metric);
        }
        catch (IllegalArgumentException e) {
            log.warn("Metric {} already registered, skipping registration", (Object)metricName);
            Metric existingMetric = (Metric)INSTANCE.getRegistry().getMetrics().get(metricName);
            return (T)existingMetric;
        }
    }

    public static Gauge getGauge(Class<?> callerClass, String key) {
        String metricName = MetricRegistry.name(callerClass, (String[])new String[]{key});
        return (Gauge)INSTANCE.getRegistry().getGauges().get(metricName);
    }

    public static void incrementCounter(String name) {
        INSTANCE.getRegistry().counter(name).inc();
    }

    public static Timer.Context timerContext(String metricName) {
        return INSTANCE.getRegistry().timer(MetricRegistry.name((String)metricName, (String[])new String[0])).time();
    }

    public static Timer.Context timerContext(Class<?> callerClass, String ... names) {
        return INSTANCE.getRegistry().timer(MetricRegistry.name(callerClass, (String[])names)).time();
    }

    public static void histogram(Class<?> callerClass, long number, String ... names) {
        INSTANCE.getRegistry().histogram(MetricRegistry.name(callerClass, (String[])names)).update(number);
    }

    public static void histogram(long number, String ... names) {
        String name = MetricsRegistry.join(names);
        INSTANCE.getRegistry().histogram(MetricRegistry.name((String)name, (String[])new String[0])).update(number);
    }

    public static void markMeter(String ... names) {
        String name = MetricsRegistry.join(names);
        INSTANCE.getRegistry().meter(MetricRegistry.name((String)name, (String[])new String[0])).mark();
    }

    public static void markMeter(Class<?> callerClass, long count, String ... names) {
        INSTANCE.getRegistry().meter(MetricRegistry.name(callerClass, (String[])names)).mark(count);
    }

    public static void markMeter(Class<?> callerClass, String ... names) {
        MetricsRegistry.markMeter(callerClass, 1L, names);
    }

    private static String join(String ... values) {
        return String.join((CharSequence)SEPARATOR, values);
    }

    public MetricRegistry getRegistry() {
        return this.metricRegistry;
    }

    public static MetricRegistry getMetricRegistry() {
        return INSTANCE.getRegistry();
    }

    static {
        log = LoggerFactory.getLogger(MetricsRegistry.class);
    }
}

