/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.drift.commons.model.resolvedDetails;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.flipkart.drift.commons.model.enums.HttpContentTypeEnum;
import com.flipkart.drift.commons.model.enums.HttpMethod;
import com.flipkart.drift.commons.model.resolvedDetails.ResolvedDetails;
import java.util.HashMap;
import java.util.Map;

public class HttpDetails
implements ResolvedDetails {
    private final String url;
    private final HttpMethod method;
    private final HttpContentTypeEnum contentType;
    private final Map<String, String> queryParams;
    private final Map<String, Object> body;
    private Map<String, String> headers;
    private final String targetClientId;

    @JsonCreator
    public HttpDetails(@JsonProperty(value="url") String url, @JsonProperty(value="method") HttpMethod method, @JsonProperty(value="contentType") HttpContentTypeEnum contentType, @JsonProperty(value="headers") Map<String, String> headers, @JsonProperty(value="queryParams") Map<String, String> queryParams, @JsonProperty(value="body") Map<String, Object> body, @JsonProperty(value="targetClientId") String targetClientId) {
        this.url = url;
        this.method = method;
        this.contentType = contentType;
        this.headers = headers;
        this.queryParams = queryParams;
        this.body = body;
        this.targetClientId = targetClientId;
        if (null == this.headers) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put("Content-Type", contentType.toString());
    }

    public static HttpDetailsBuilder builder() {
        return new HttpDetailsBuilder();
    }

    public String getUrl() {
        return this.url;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public HttpContentTypeEnum getContentType() {
        return this.contentType;
    }

    public Map<String, String> getQueryParams() {
        return this.queryParams;
    }

    public Map<String, Object> getBody() {
        return this.body;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getTargetClientId() {
        return this.targetClientId;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public String toString() {
        return "HttpDetails(super=" + super.toString() + ", url=" + this.getUrl() + ", method=" + String.valueOf((Object)this.getMethod()) + ", contentType=" + String.valueOf((Object)this.getContentType()) + ", queryParams=" + String.valueOf(this.getQueryParams()) + ", body=" + String.valueOf(this.getBody()) + ", headers=" + String.valueOf(this.getHeaders()) + ", targetClientId=" + this.getTargetClientId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpDetails)) {
            return false;
        }
        HttpDetails other = (HttpDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        HttpMethod this$method = this.getMethod();
        HttpMethod other$method = other.getMethod();
        if (this$method == null ? other$method != null : !((Object)((Object)this$method)).equals((Object)other$method)) {
            return false;
        }
        HttpContentTypeEnum this$contentType = this.getContentType();
        HttpContentTypeEnum other$contentType = other.getContentType();
        if (this$contentType == null ? other$contentType != null : !((Object)((Object)this$contentType)).equals((Object)other$contentType)) {
            return false;
        }
        Map<String, String> this$queryParams = this.getQueryParams();
        Map<String, String> other$queryParams = other.getQueryParams();
        if (this$queryParams == null ? other$queryParams != null : !((Object)this$queryParams).equals(other$queryParams)) {
            return false;
        }
        Map<String, Object> this$body = this.getBody();
        Map<String, Object> other$body = other.getBody();
        if (this$body == null ? other$body != null : !((Object)this$body).equals(other$body)) {
            return false;
        }
        Map<String, String> this$headers = this.getHeaders();
        Map<String, String> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        String this$targetClientId = this.getTargetClientId();
        String other$targetClientId = other.getTargetClientId();
        return !(this$targetClientId == null ? other$targetClientId != null : !this$targetClientId.equals(other$targetClientId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpDetails;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        HttpMethod $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : ((Object)((Object)$method)).hashCode());
        HttpContentTypeEnum $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : ((Object)((Object)$contentType)).hashCode());
        Map<String, String> $queryParams = this.getQueryParams();
        result = result * 59 + ($queryParams == null ? 43 : ((Object)$queryParams).hashCode());
        Map<String, Object> $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : ((Object)$body).hashCode());
        Map<String, String> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        String $targetClientId = this.getTargetClientId();
        result = result * 59 + ($targetClientId == null ? 43 : $targetClientId.hashCode());
        return result;
    }

    public static class HttpDetailsBuilder {
        private String url;
        private HttpMethod method;
        private HttpContentTypeEnum contentType;
        private Map<String, String> headers;
        private Map<String, String> queryParams;
        private Map<String, Object> body;
        private String targetClientId;

        HttpDetailsBuilder() {
        }

        @JsonProperty(value="url")
        public HttpDetailsBuilder url(String url) {
            this.url = url;
            return this;
        }

        @JsonProperty(value="method")
        public HttpDetailsBuilder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        @JsonProperty(value="contentType")
        public HttpDetailsBuilder contentType(HttpContentTypeEnum contentType) {
            this.contentType = contentType;
            return this;
        }

        @JsonProperty(value="headers")
        public HttpDetailsBuilder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        @JsonProperty(value="queryParams")
        public HttpDetailsBuilder queryParams(Map<String, String> queryParams) {
            this.queryParams = queryParams;
            return this;
        }

        @JsonProperty(value="body")
        public HttpDetailsBuilder body(Map<String, Object> body) {
            this.body = body;
            return this;
        }

        @JsonProperty(value="targetClientId")
        public HttpDetailsBuilder targetClientId(String targetClientId) {
            this.targetClientId = targetClientId;
            return this;
        }

        public HttpDetails build() {
            return new HttpDetails(this.url, this.method, this.contentType, this.headers, this.queryParams, this.body, this.targetClientId);
        }

        public String toString() {
            return "HttpDetails.HttpDetailsBuilder(url=" + this.url + ", method=" + String.valueOf((Object)this.method) + ", contentType=" + String.valueOf((Object)this.contentType) + ", headers=" + String.valueOf(this.headers) + ", queryParams=" + String.valueOf(this.queryParams) + ", body=" + String.valueOf(this.body) + ", targetClientId=" + this.targetClientId + ")";
        }
    }
}

