/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.drift.commons.model.clientComponent;

import com.flipkart.drift.commons.model.clientComponent.ClientComponents;
import com.flipkart.drift.commons.model.componentDetail.ComponentDetail;
import com.flipkart.drift.commons.model.enums.HttpContentTypeEnum;
import com.flipkart.drift.commons.model.enums.HttpMethod;
import com.flipkart.drift.commons.model.value.StringValue;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpComponents
extends ClientComponents {
    private static final Logger log = LoggerFactory.getLogger(HttpComponents.class);
    private ComponentDetail<StringValue, String> url;
    private ComponentDetail<StringValue, Map> headers;
    private ComponentDetail<StringValue, Map> queryParams;
    private ComponentDetail<StringValue, Map> body;
    private HttpMethod method;
    private HttpContentTypeEnum contentType;
    private String targetClientId;

    @Override
    protected String getComponentSpecificHashInput() {
        StringBuilder input = new StringBuilder();
        if (this.url != null) {
            input.append(this.url);
        }
        if (this.headers != null) {
            input.append(this.headers);
        }
        if (this.queryParams != null) {
            input.append(this.queryParams);
        }
        if (this.body != null) {
            input.append(this.body);
        }
        if (this.method != null) {
            input.append((Object)this.method);
        }
        if (this.contentType != null) {
            input.append((Object)this.contentType);
        }
        if (this.targetClientId != null) {
            input.append(this.targetClientId);
        }
        return input.toString();
    }

    public static HttpComponentsBuilder builder() {
        return new HttpComponentsBuilder();
    }

    public ComponentDetail<StringValue, String> getUrl() {
        return this.url;
    }

    public ComponentDetail<StringValue, Map> getHeaders() {
        return this.headers;
    }

    public ComponentDetail<StringValue, Map> getQueryParams() {
        return this.queryParams;
    }

    public ComponentDetail<StringValue, Map> getBody() {
        return this.body;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public HttpContentTypeEnum getContentType() {
        return this.contentType;
    }

    public String getTargetClientId() {
        return this.targetClientId;
    }

    public void setUrl(ComponentDetail<StringValue, String> url) {
        this.url = url;
    }

    public void setHeaders(ComponentDetail<StringValue, Map> headers) {
        this.headers = headers;
    }

    public void setQueryParams(ComponentDetail<StringValue, Map> queryParams) {
        this.queryParams = queryParams;
    }

    public void setBody(ComponentDetail<StringValue, Map> body) {
        this.body = body;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    public void setContentType(HttpContentTypeEnum contentType) {
        this.contentType = contentType;
    }

    public void setTargetClientId(String targetClientId) {
        this.targetClientId = targetClientId;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpComponents)) {
            return false;
        }
        HttpComponents other = (HttpComponents)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ComponentDetail<StringValue, String> this$url = this.getUrl();
        ComponentDetail<StringValue, String> other$url = other.getUrl();
        if (this$url == null ? other$url != null : !((Object)this$url).equals(other$url)) {
            return false;
        }
        ComponentDetail<StringValue, Map> this$headers = this.getHeaders();
        ComponentDetail<StringValue, Map> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        ComponentDetail<StringValue, Map> this$queryParams = this.getQueryParams();
        ComponentDetail<StringValue, Map> other$queryParams = other.getQueryParams();
        if (this$queryParams == null ? other$queryParams != null : !((Object)this$queryParams).equals(other$queryParams)) {
            return false;
        }
        ComponentDetail<StringValue, Map> this$body = this.getBody();
        ComponentDetail<StringValue, Map> other$body = other.getBody();
        if (this$body == null ? other$body != null : !((Object)this$body).equals(other$body)) {
            return false;
        }
        HttpMethod this$method = this.getMethod();
        HttpMethod other$method = other.getMethod();
        if (this$method == null ? other$method != null : !((Object)((Object)this$method)).equals((Object)other$method)) {
            return false;
        }
        HttpContentTypeEnum this$contentType = this.getContentType();
        HttpContentTypeEnum other$contentType = other.getContentType();
        if (this$contentType == null ? other$contentType != null : !((Object)((Object)this$contentType)).equals((Object)other$contentType)) {
            return false;
        }
        String this$targetClientId = this.getTargetClientId();
        String other$targetClientId = other.getTargetClientId();
        return !(this$targetClientId == null ? other$targetClientId != null : !this$targetClientId.equals(other$targetClientId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HttpComponents;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ComponentDetail<StringValue, String> $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : ((Object)$url).hashCode());
        ComponentDetail<StringValue, Map> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        ComponentDetail<StringValue, Map> $queryParams = this.getQueryParams();
        result = result * 59 + ($queryParams == null ? 43 : ((Object)$queryParams).hashCode());
        ComponentDetail<StringValue, Map> $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : ((Object)$body).hashCode());
        HttpMethod $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : ((Object)((Object)$method)).hashCode());
        HttpContentTypeEnum $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : ((Object)((Object)$contentType)).hashCode());
        String $targetClientId = this.getTargetClientId();
        result = result * 59 + ($targetClientId == null ? 43 : $targetClientId.hashCode());
        return result;
    }

    public HttpComponents(ComponentDetail<StringValue, String> url, ComponentDetail<StringValue, Map> headers, ComponentDetail<StringValue, Map> queryParams, ComponentDetail<StringValue, Map> body, HttpMethod method, HttpContentTypeEnum contentType, String targetClientId) {
        this.url = url;
        this.headers = headers;
        this.queryParams = queryParams;
        this.body = body;
        this.method = method;
        this.contentType = contentType;
        this.targetClientId = targetClientId;
    }

    public HttpComponents() {
    }

    @Override
    public String toString() {
        return "HttpComponents(url=" + String.valueOf(this.getUrl()) + ", headers=" + String.valueOf(this.getHeaders()) + ", queryParams=" + String.valueOf(this.getQueryParams()) + ", body=" + String.valueOf(this.getBody()) + ", method=" + String.valueOf((Object)this.getMethod()) + ", contentType=" + String.valueOf((Object)this.getContentType()) + ", targetClientId=" + this.getTargetClientId() + ")";
    }

    public static class HttpComponentsBuilder {
        private ComponentDetail<StringValue, String> url;
        private ComponentDetail<StringValue, Map> headers;
        private ComponentDetail<StringValue, Map> queryParams;
        private ComponentDetail<StringValue, Map> body;
        private HttpMethod method;
        private HttpContentTypeEnum contentType;
        private String targetClientId;

        HttpComponentsBuilder() {
        }

        public HttpComponentsBuilder url(ComponentDetail<StringValue, String> url) {
            this.url = url;
            return this;
        }

        public HttpComponentsBuilder headers(ComponentDetail<StringValue, Map> headers) {
            this.headers = headers;
            return this;
        }

        public HttpComponentsBuilder queryParams(ComponentDetail<StringValue, Map> queryParams) {
            this.queryParams = queryParams;
            return this;
        }

        public HttpComponentsBuilder body(ComponentDetail<StringValue, Map> body) {
            this.body = body;
            return this;
        }

        public HttpComponentsBuilder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        public HttpComponentsBuilder contentType(HttpContentTypeEnum contentType) {
            this.contentType = contentType;
            return this;
        }

        public HttpComponentsBuilder targetClientId(String targetClientId) {
            this.targetClientId = targetClientId;
            return this;
        }

        public HttpComponents build() {
            return new HttpComponents(this.url, this.headers, this.queryParams, this.body, this.method, this.contentType, this.targetClientId);
        }

        public String toString() {
            return "HttpComponents.HttpComponentsBuilder(url=" + String.valueOf(this.url) + ", headers=" + String.valueOf(this.headers) + ", queryParams=" + String.valueOf(this.queryParams) + ", body=" + String.valueOf(this.body) + ", method=" + String.valueOf((Object)this.method) + ", contentType=" + String.valueOf((Object)this.contentType) + ", targetClientId=" + this.targetClientId + ")";
        }
    }
}

