/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.drift.commons.model.clientComponent;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.flipkart.drift.commons.model.componentDetail.ComponentDetail;
import com.flipkart.drift.commons.model.value.MapValue;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class ClientComponents {
    @JsonIgnore
    private ComponentDetail<MapValue, Map> scriptedFieldsInfoMap;

    protected abstract String getComponentSpecificHashInput();

    public String computeUniqueComponentHash() {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            String componentSpecificInput = this.getComponentSpecificHashInput();
            if (componentSpecificInput != null) {
                digest.update(componentSpecificInput.getBytes());
            }
            byte[] hashBytes = digest.digest();
            StringBuilder hexString = new StringBuilder();
            for (byte b : hashBytes) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Failed to generate component hash", e);
        }
    }

    public ComponentDetail<MapValue, Map> getScriptedFieldsInfoMap() {
        return this.scriptedFieldsInfoMap;
    }

    @JsonIgnore
    public void setScriptedFieldsInfoMap(ComponentDetail<MapValue, Map> scriptedFieldsInfoMap) {
        this.scriptedFieldsInfoMap = scriptedFieldsInfoMap;
    }

    public String toString() {
        return "ClientComponents(scriptedFieldsInfoMap=" + String.valueOf(this.getScriptedFieldsInfoMap()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientComponents)) {
            return false;
        }
        ClientComponents other = (ClientComponents)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ComponentDetail<MapValue, Map> this$scriptedFieldsInfoMap = this.getScriptedFieldsInfoMap();
        ComponentDetail<MapValue, Map> other$scriptedFieldsInfoMap = other.getScriptedFieldsInfoMap();
        return !(this$scriptedFieldsInfoMap == null ? other$scriptedFieldsInfoMap != null : !((Object)this$scriptedFieldsInfoMap).equals(other$scriptedFieldsInfoMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientComponents;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ComponentDetail<MapValue, Map> $scriptedFieldsInfoMap = this.getScriptedFieldsInfoMap();
        result = result * 59 + ($scriptedFieldsInfoMap == null ? 43 : ((Object)$scriptedFieldsInfoMap).hashCode());
        return result;
    }
}

