/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.drift.api.service.utils;

import com.flipkart.drift.commons.model.enums.NodeType;
import guru.nidi.graphviz.attribute.Color;
import guru.nidi.graphviz.attribute.Shape;
import java.util.ArrayList;
import java.util.List;

public class WorkflowGraphNode {
    String name;
    NodeType type;
    Shape shape;
    Color color;
    String nextNode = null;
    List<String> choices = new ArrayList<String>();

    public WorkflowGraphNode(String name, NodeType type, String nextNode, List<String> choices) {
        this.name = name;
        this.type = type;
        this.shape = this.getShape(type);
        this.color = this.getColor(type);
        this.nextNode = nextNode;
        this.choices = choices;
    }

    Shape getShape(NodeType type) {
        switch (type) {
            case BRANCH: {
                return Shape.DIAMOND;
            }
            case PROCESSOR: {
                return Shape.RECTANGLE;
            }
        }
        return Shape.ELLIPSE;
    }

    private Color getColor(NodeType type) {
        switch (type) {
            case BRANCH: {
                return Color.TAN1;
            }
            case INSTRUCTION: {
                return Color.YELLOW;
            }
            case HTTP: {
                return Color.DEEPSKYBLUE;
            }
            case FAILURE: {
                return Color.FIREBRICK1;
            }
            case GROOVY: {
                return Color.MEDIUMSPRINGGREEN;
            }
            case PROCESSOR: {
                return Color.GREY;
            }
        }
        return Color.LIGHTPINK;
    }

    public String getName() {
        return this.name;
    }

    public NodeType getType() {
        return this.type;
    }

    public Shape getShape() {
        return this.shape;
    }

    public Color getColor() {
        return this.color;
    }

    public String getNextNode() {
        return this.nextNode;
    }

    public List<String> getChoices() {
        return this.choices;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(NodeType type) {
        this.type = type;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setNextNode(String nextNode) {
        this.nextNode = nextNode;
    }

    public void setChoices(List<String> choices) {
        this.choices = choices;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkflowGraphNode)) {
            return false;
        }
        WorkflowGraphNode other = (WorkflowGraphNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        NodeType this$type = this.getType();
        NodeType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Shape this$shape = this.getShape();
        Shape other$shape = other.getShape();
        if (this$shape == null ? other$shape != null : !this$shape.equals(other$shape)) {
            return false;
        }
        Color this$color = this.getColor();
        Color other$color = other.getColor();
        if (this$color == null ? other$color != null : !this$color.equals(other$color)) {
            return false;
        }
        String this$nextNode = this.getNextNode();
        String other$nextNode = other.getNextNode();
        if (this$nextNode == null ? other$nextNode != null : !this$nextNode.equals(other$nextNode)) {
            return false;
        }
        List<String> this$choices = this.getChoices();
        List<String> other$choices = other.getChoices();
        return !(this$choices == null ? other$choices != null : !((Object)this$choices).equals(other$choices));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WorkflowGraphNode;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        NodeType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Shape $shape = this.getShape();
        result = result * 59 + ($shape == null ? 43 : $shape.hashCode());
        Color $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : $color.hashCode());
        String $nextNode = this.getNextNode();
        result = result * 59 + ($nextNode == null ? 43 : $nextNode.hashCode());
        List<String> $choices = this.getChoices();
        result = result * 59 + ($choices == null ? 43 : ((Object)$choices).hashCode());
        return result;
    }

    public String toString() {
        return "WorkflowGraphNode(name=" + this.getName() + ", type=" + String.valueOf(this.getType()) + ", shape=" + String.valueOf(this.getShape()) + ", color=" + String.valueOf(this.getColor()) + ", nextNode=" + this.getNextNode() + ", choices=" + String.valueOf(this.getChoices()) + ")";
    }
}

