/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.drift.api.service.utils;

import com.google.inject.Singleton;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisSentinelPool;

@Singleton
public class Utility {
    private static final Logger log = LoggerFactory.getLogger(Utility.class);
    private static final String WORKFLOW_ID_PREFIX = "WF-";
    private static final DateTimeFormatter ID_DATE_FORMAT = DateTimeFormatter.ofPattern("yyMMddHHmmssSSS");
    private static final int RANDOM_ID_BOUND = 100000;
    private static final String RANDOM_ID_FORMAT = "%05d";

    public String generateWorkflowId(String externalIncidentId, boolean isIncidentCreationAllowed) {
        if (isIncidentCreationAllowed) {
            return WORKFLOW_ID_PREFIX + externalIncidentId;
        }
        return this.generateRandomWorkflowId();
    }

    private String generateRandomWorkflowId() {
        String timestamp = LocalDateTime.now().format(ID_DATE_FORMAT);
        int randomNumber = ThreadLocalRandom.current().nextInt(100000);
        return WORKFLOW_ID_PREFIX + timestamp + String.format(RANDOM_ID_FORMAT, randomNumber);
    }

    public static Long publishRedisEvent(JedisSentinelPool jedisSentinelPool, String channel, String message) {
        Jedis jedis = jedisSentinelPool.getResource();
        log.info("Publishing redis event to {}, msg: {}", (Object)channel, (Object)message);
        Long status = jedis.publish(channel, message);
        jedis.close();
        return status;
    }
}

