/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.drift.api.service.builder;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.drift.api.service.builder.NodeDefinitionService;
import com.flipkart.drift.api.service.utils.Utility;
import com.flipkart.drift.api.service.utils.WorkflowGraphNode;
import com.flipkart.drift.commons.exception.ApiException;
import com.flipkart.drift.commons.model.enums.NodeType;
import com.flipkart.drift.commons.model.enums.Version;
import com.flipkart.drift.commons.model.node.BranchNode;
import com.flipkart.drift.commons.model.node.NodeDefinition;
import com.flipkart.drift.commons.model.node.Workflow;
import com.flipkart.drift.persistence.dao.ConnectionType;
import com.flipkart.drift.persistence.dao.WorkflowDefinitionDao;
import com.flipkart.drift.persistence.entity.WorkflowHB;
import com.flipkart.hbaseobjectmapper.HBRecord;
import com.google.inject.Inject;
import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.Color;
import guru.nidi.graphviz.attribute.Font;
import guru.nidi.graphviz.attribute.RankDir;
import guru.nidi.graphviz.attribute.Style;
import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.Graphviz;
import guru.nidi.graphviz.engine.GraphvizEngine;
import guru.nidi.graphviz.engine.GraphvizJdkEngine;
import guru.nidi.graphviz.model.Factory;
import guru.nidi.graphviz.model.Graph;
import guru.nidi.graphviz.model.Link;
import guru.nidi.graphviz.model.LinkSource;
import guru.nidi.graphviz.model.LinkTarget;
import guru.nidi.graphviz.model.Node;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisSentinelPool;

public class WorkflowDefinitionService {
    private static final Logger log = LoggerFactory.getLogger(WorkflowDefinitionService.class);
    public static final String WORKFLOW_EVENT_ID = "WORKFLOW";
    private final WorkflowDefinitionDao workflowDefinitionDao;
    private final JedisSentinelPool jedisSentinelPool;
    private final NodeDefinitionService nodeDefinitionService;

    @Inject
    public WorkflowDefinitionService(WorkflowDefinitionDao workflowDefinitionDao, ObjectMapper objectMapper, JedisSentinelPool jedisSentinelPool, NodeDefinitionService nodeDefinitionService) {
        this.workflowDefinitionDao = workflowDefinitionDao;
        this.jedisSentinelPool = jedisSentinelPool;
        this.nodeDefinitionService = nodeDefinitionService;
    }

    public Workflow addWorkflow(Workflow workflowData) {
        workflowData.validateWFFields();
        String workflowKey = com.flipkart.drift.commons.utils.Utility.generateRowKey((String)workflowData.getId(), (Object)Version.SNAPSHOT);
        this.checkWorkflowExistence(workflowKey);
        this.createWorkflow(workflowKey, workflowData);
        return workflowData;
    }

    public Workflow updateWorkflow(Workflow workflowData) throws JsonProcessingException {
        String workflowKey = com.flipkart.drift.commons.utils.Utility.generateRowKey((String)workflowData.getId(), (Object)Version.SNAPSHOT);
        WorkflowHB existingWorkflowHB = this.getWorkflowHB(workflowKey);
        Workflow existingWorkflow = existingWorkflowHB.getWorkflowData();
        if (workflowData.getComment() != null) {
            existingWorkflow.setComment(workflowData.getComment());
        }
        if (workflowData.getStartNode() != null) {
            existingWorkflow.setStartNode(workflowData.getStartNode());
        }
        if (workflowData.getVersion() != null) {
            existingWorkflow.setVersion(workflowData.getVersion());
        }
        if (workflowData.getDefaultFailureNode() != null) {
            existingWorkflow.setDefaultFailureNode(workflowData.getDefaultFailureNode());
        }
        if (workflowData.getPostWorkflowCompletionNodes() != null) {
            existingWorkflow.setPostWorkflowCompletionNodes(workflowData.getPostWorkflowCompletionNodes());
        }
        if (workflowData.getStates() != null) {
            if (existingWorkflow.getStates() == null) {
                existingWorkflow.setStates(workflowData.getStates());
            } else {
                workflowData.getStates().forEach((key, value) -> existingWorkflow.getStates().put(key, value));
            }
        }
        this.updateWorkflowInHBase(workflowKey, existingWorkflow);
        return existingWorkflow;
    }

    public Workflow getWorkflowById(String id, String version) {
        String workflowKey = com.flipkart.drift.commons.utils.Utility.generateRowKey((String)id, (Object)com.flipkart.drift.commons.utils.Utility.parseVersion((String)version));
        return this.getWorkflowFromWorkflowHB(workflowKey);
    }

    public Workflow getWorkflowById(String id, String version, boolean enrichNodeDefinition) {
        Workflow workflow = this.getWorkflowById(id, version);
        if (enrichNodeDefinition && workflow.getStates() != null) {
            workflow.getStates().forEach((stateId, state) -> {
                NodeDefinition nodeDefinition = this.nodeDefinitionService.getNodeById(state.getResourceId(), state.getResourceVersion());
                state.setNodeDefinition(nodeDefinition);
            });
        }
        return workflow;
    }

    public File getWorkflowDiagram(String id, String version, String mode) {
        Graphviz.useEngine((GraphvizEngine)new GraphvizJdkEngine(), (GraphvizEngine[])new GraphvizEngine[0]);
        String workflowKey = com.flipkart.drift.commons.utils.Utility.generateRowKey((String)id, (Object)com.flipkart.drift.commons.utils.Utility.parseVersion((String)version));
        Workflow workflow = this.getWorkflowFromWorkflowHB(workflowKey);
        HashMap<String, WorkflowGraphNode> workflowGraph = new HashMap<String, WorkflowGraphNode>();
        HashMap graphNodes = new HashMap();
        String workflowName = workflow.getId().toUpperCase();
        WorkflowGraphNode startWorkflowNode = new WorkflowGraphNode(workflowName, NodeType.PROCESSOR, workflow.getStartNode(), this.getBranchChoices(null));
        workflowGraph.put(startWorkflowNode.getName(), startWorkflowNode);
        if (workflow.getStates() != null) {
            workflow.getStates().forEach((stateId, state) -> {
                NodeDefinition nodeDef = this.nodeDefinitionService.getNodeById(state.getResourceId(), state.getResourceVersion());
                WorkflowGraphNode workflowGraphNode = new WorkflowGraphNode(state.getInstanceName(), nodeDef.getType(), state.getNextNode(), this.getBranchChoices(nodeDef));
                workflowGraph.put(state.getInstanceName(), workflowGraphNode);
            });
        }
        Graph baseGraph = (Graph)Factory.graph((String)"Workflow").directed().graphAttr().with((Attributes)RankDir.TOP_TO_BOTTOM);
        if (Objects.equals(mode, "dark")) {
            baseGraph = (Graph)((Graph)baseGraph.graphAttr().with((Attributes)RankDir.TOP_TO_BOTTOM, (Attributes)Color.rgb((String)"0E0E0E").background(), (Attributes)Color.rgb((String)"FFFFFF").font(), Font.name((String)"Consolas"))).linkAttr().with((Attributes)Color.rgb((String)"FFFFFF"));
        }
        AtomicReference<Graph> graphRef = new AtomicReference<Graph>(baseGraph);
        workflowGraph.forEach((stateId, nodeData) -> {
            Node graphNode = (Node)((Node)((Node)Factory.node((String)nodeData.getName()).with((Attributes)Style.FILLED)).with((Attributes)nodeData.getShape())).with((Attributes)nodeData.getColor());
            graphNodes.put(nodeData.getName(), graphNode);
            graphRef.set(((Graph)graphRef.get()).with(new LinkSource[]{graphNode}));
        });
        workflowGraph.forEach((stateId, nodeData) -> {
            Node current = (Node)graphNodes.get(nodeData.getName());
            if (nodeData.getType() == NodeType.BRANCH && nodeData.getChoices() != null) {
                Node[] choiceNodes = (Node[])nodeData.getChoices().stream().filter(graphNodes::containsKey).map(graphNodes::get).toArray(Node[]::new);
                if (choiceNodes.length > 0) {
                    Node linkedNode = current;
                    for (Node choiceNode : choiceNodes) {
                        linkedNode = linkedNode.link(new LinkTarget[]{Link.to((Node)choiceNode)});
                    }
                    graphRef.set(((Graph)graphRef.get()).with(new LinkSource[]{linkedNode}));
                }
            } else if (nodeData.getNextNode() != null && graphNodes.containsKey(nodeData.getNextNode())) {
                graphRef.set(((Graph)graphRef.get()).with(new LinkSource[]{current.link(new LinkTarget[]{Link.to((Node)((Node)graphNodes.get(nodeData.getNextNode())))})}));
            }
        });
        try {
            File workflowDiagram = File.createTempFile("workflow-" + System.currentTimeMillis(), ".png");
            Graphviz.fromGraph((Graph)graphRef.get()).render(Format.PNG).toFile(workflowDiagram);
            workflowDiagram.deleteOnExit();
            return workflowDiagram;
        }
        catch (IOException e) {
            log.error("Error while generating workflow diagram", (Throwable)e);
            throw new ApiException("Error while generating workflow diagram", (Throwable)e);
        }
    }

    private List<String> getBranchChoices(NodeDefinition nodeDefinition) {
        ArrayList<String> branchChoices = new ArrayList<String>();
        if (nodeDefinition != null && nodeDefinition.getType() == NodeType.BRANCH) {
            ((BranchNode)nodeDefinition).getChoices().forEach(choice -> branchChoices.add(choice.getNextNode()));
        }
        return branchChoices;
    }

    public void publishWorkflow(String id) {
        try {
            Integer version;
            String snapshotKey = com.flipkart.drift.commons.utils.Utility.generateRowKey((String)id, (Object)Version.SNAPSHOT);
            WorkflowHB snapshotWorkflowHB = this.getWorkflowHB(snapshotKey);
            Workflow workflow = snapshotWorkflowHB.getWorkflowData();
            String latestKey = com.flipkart.drift.commons.utils.Utility.generateRowKey((String)id, (Object)Version.LATEST);
            WorkflowHB latestWorkflowHB = (WorkflowHB)this.workflowDefinitionDao.get((Serializable)((Object)latestKey), ConnectionType.HOT);
            if (latestWorkflowHB == null) {
                Integer version2 = 1;
                workflow.setVersion(String.valueOf(version2));
                this.createWorkflow(latestKey, workflow);
                String versionKey = com.flipkart.drift.commons.utils.Utility.generateRowKey((String)id, (Object)version2);
                this.createWorkflow(versionKey, workflow);
                Utility.publishRedisEvent(this.jedisSentinelPool, "+dsl-update:", "WORKFLOW " + versionKey);
                Utility.publishRedisEvent(this.jedisSentinelPool, "+dsl-update:", "WORKFLOW " + latestKey);
                return;
            }
            Workflow latestWorkflow = latestWorkflowHB.getWorkflowData();
            Integer n = version = com.flipkart.drift.commons.utils.Utility.StringToIntegerVersionParser((String)latestWorkflow.getVersion());
            version = version + 1;
            workflow.setVersion(String.valueOf(version));
            String versionKey = com.flipkart.drift.commons.utils.Utility.generateRowKey((String)id, (Object)version);
            this.createWorkflow(versionKey, workflow);
            this.updateWorkflowInHBase(latestKey, workflow);
            Utility.publishRedisEvent(this.jedisSentinelPool, "+dsl-update:", "WORKFLOW " + versionKey);
            Utility.publishRedisEvent(this.jedisSentinelPool, "+dsl-update:", "WORKFLOW " + latestKey);
        }
        catch (Exception e) {
            throw new ApiException("Error while publishing workflow in HBase", Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    private void checkWorkflowExistence(String workflowKey) {
        try {
            if (this.workflowDefinitionDao.get((Serializable)((Object)workflowKey), ConnectionType.HOT) != null) {
                throw new ApiException(Response.Status.BAD_REQUEST, "Workflow with id already exists");
            }
        }
        catch (IOException e) {
            throw new ApiException("Error while checking workflow existence in HBase", Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    private void createWorkflow(String workflowKey, Workflow workflowData) {
        try {
            WorkflowHB workflowHB = new WorkflowHB();
            workflowHB.setWorkflowKey(workflowKey);
            workflowHB.setWorkflowData(workflowData);
            this.workflowDefinitionDao.create((HBRecord)workflowHB, ConnectionType.HOT);
        }
        catch (IOException e) {
            throw new ApiException("Error while creating workflow in HBase", Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    private void updateWorkflowInHBase(String workflowKey, Workflow workflowData) {
        try {
            WorkflowHB workflowHB = new WorkflowHB();
            workflowHB.setWorkflowKey(workflowKey);
            workflowHB.setWorkflowData(workflowData);
            this.workflowDefinitionDao.update((HBRecord)workflowHB, (Serializable)((Object)workflowKey), ConnectionType.HOT);
        }
        catch (IOException e) {
            throw new ApiException("Error while updating workflow in HBase", Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    private Workflow getWorkflowFromWorkflowHB(String workflowKey) {
        try {
            WorkflowHB workflowHB = (WorkflowHB)this.workflowDefinitionDao.get((Serializable)((Object)workflowKey), ConnectionType.HOT);
            if (workflowHB == null) {
                throw new ApiException(Response.Status.BAD_REQUEST, "Workflow not found");
            }
            return workflowHB.getWorkflowData();
        }
        catch (IOException e) {
            throw new ApiException("Error while fetching workflow from WorkflowHB in HBase", Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    public void markActive(String id, Integer versionId) {
        String versionKey = com.flipkart.drift.commons.utils.Utility.generateRowKey((String)id, (Object)versionId);
        WorkflowHB versionWorkflowHB = this.getWorkflowHB(versionKey);
        Workflow workflow = versionWorkflowHB.getWorkflowData();
        String activeKey = com.flipkart.drift.commons.utils.Utility.generateRowKey((String)id, (Object)Version.ACTIVE);
        this.createWorkflow(activeKey, workflow);
        Utility.publishRedisEvent(this.jedisSentinelPool, "+dsl-update:", "WORKFLOW " + activeKey);
    }

    private WorkflowHB getWorkflowHB(String workflowKey) {
        try {
            WorkflowHB workflowHB = (WorkflowHB)this.workflowDefinitionDao.get((Serializable)((Object)workflowKey), ConnectionType.HOT);
            if (workflowHB == null) {
                throw new ApiException(Response.Status.BAD_REQUEST, "Workflow not found");
            }
            return workflowHB;
        }
        catch (IOException e) {
            throw new ApiException("Error while fetching workflow from WorkflowHB in HBase", Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }
}

