/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.drift.api.service.builder;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.drift.commons.model.enums.Version;
import com.flipkart.drift.commons.model.node.NodeDefinition;
import com.flipkart.drift.commons.utils.Utility;
import com.flipkart.drift.persistence.dao.ConnectionType;
import com.flipkart.drift.persistence.dao.NodeDefinitionDao;
import com.flipkart.drift.persistence.entity.NodeHB;
import com.flipkart.drift.persistence.exception.ApiException;
import com.flipkart.hbaseobjectmapper.HBRecord;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.Serializable;
import javax.ws.rs.core.Response;
import redis.clients.jedis.JedisSentinelPool;

public class NodeDefinitionService {
    public static final String NODE_EVENT_ID = "NODE";
    private final NodeDefinitionDao nodeDefinitionDao;
    private final JedisSentinelPool jedisSentinelPool;

    @Inject
    public NodeDefinitionService(NodeDefinitionDao nodeDefinitionDao, ObjectMapper objectMapper, JedisSentinelPool jedisSentinelPool) {
        this.nodeDefinitionDao = nodeDefinitionDao;
        this.jedisSentinelPool = jedisSentinelPool;
    }

    public NodeDefinition addNode(NodeDefinition wfNodeData) {
        wfNodeData.validateWFNodeFields();
        String nodeKey = Utility.generateRowKey((String)wfNodeData.getId(), (Object)Version.SNAPSHOT);
        this.checkNodeExistence(nodeKey);
        this.createNode(nodeKey, wfNodeData);
        return wfNodeData;
    }

    public NodeDefinition updateNode(NodeDefinition wfNodeData) throws IOException {
        String nodeKey = Utility.generateRowKey((String)wfNodeData.getId(), (Object)Version.SNAPSHOT);
        NodeHB existingNodeHB = this.getNodeHB(nodeKey);
        NodeDefinition existingNode = this.updateExistingNode(existingNodeHB, wfNodeData);
        this.updateNodeInHBase(nodeKey, existingNode);
        return wfNodeData;
    }

    public NodeDefinition getNodeById(String id, String version) {
        String nodeKey = Utility.generateRowKey((String)id, (Object)Utility.parseVersion((String)version));
        return this.getNodeFromNodeHB(nodeKey);
    }

    private NodeDefinition getNodeFromNodeHB(String nodeKey) {
        try {
            NodeHB nodeHB = (NodeHB)this.nodeDefinitionDao.get((Serializable)((Object)nodeKey), ConnectionType.HOT);
            if (nodeHB == null) {
                throw new ApiException(Response.Status.BAD_REQUEST, "Node not found");
            }
            return nodeHB.getNodeData();
        }
        catch (IOException e) {
            throw new ApiException("Error while fetching node from NodeHB in HBase", Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    public void publishNode(String id) {
        try {
            Integer version;
            String snapshotKey = Utility.generateRowKey((String)id, (Object)Version.SNAPSHOT);
            NodeHB snapshotNodeHB = this.getNodeHB(snapshotKey);
            NodeDefinition nodeDefinition = snapshotNodeHB.getNodeData();
            String latestKey = Utility.generateRowKey((String)id, (Object)Version.LATEST);
            NodeHB latestNodeHB = (NodeHB)this.nodeDefinitionDao.get((Serializable)((Object)latestKey), ConnectionType.HOT);
            if (latestNodeHB == null) {
                Integer version2 = 1;
                nodeDefinition.setVersion(String.valueOf(version2));
                this.createNode(latestKey, nodeDefinition);
                String versionKey = Utility.generateRowKey((String)id, (Object)version2);
                this.createNode(versionKey, nodeDefinition);
                com.flipkart.drift.api.service.utils.Utility.publishRedisEvent(this.jedisSentinelPool, "+dsl-update:", "NODE " + versionKey);
                com.flipkart.drift.api.service.utils.Utility.publishRedisEvent(this.jedisSentinelPool, "+dsl-update:", "NODE " + latestKey);
                return;
            }
            NodeDefinition latestNodeDefinition = latestNodeHB.getNodeData();
            Integer n = version = Utility.StringToIntegerVersionParser((String)latestNodeDefinition.getVersion());
            version = version + 1;
            nodeDefinition.setVersion(String.valueOf(version));
            String versionKey = Utility.generateRowKey((String)id, (Object)version);
            this.createNode(versionKey, nodeDefinition);
            this.updateNodeInHBase(Utility.generateRowKey((String)id, (Object)Version.LATEST), nodeDefinition);
            com.flipkart.drift.api.service.utils.Utility.publishRedisEvent(this.jedisSentinelPool, "+dsl-update:", "NODE " + versionKey);
            com.flipkart.drift.api.service.utils.Utility.publishRedisEvent(this.jedisSentinelPool, "+dsl-update:", "NODE " + latestKey);
        }
        catch (Exception e) {
            throw new ApiException("Error while publishing node in HBase", Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    private void checkNodeExistence(String nodeKey) {
        try {
            if (this.nodeDefinitionDao.get((Serializable)((Object)nodeKey), ConnectionType.HOT) != null) {
                throw new ApiException(Response.Status.BAD_REQUEST, "Node with name already exists");
            }
        }
        catch (IOException e) {
            throw new ApiException("Error while checking node existence in HBase", Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    private void createNode(String nodeKey, NodeDefinition wfNodeData) {
        try {
            NodeHB nodeHB = new NodeHB();
            nodeHB.setNodeKey(nodeKey);
            nodeHB.setNodeData(wfNodeData);
            this.nodeDefinitionDao.create((HBRecord)nodeHB, ConnectionType.HOT);
        }
        catch (IOException e) {
            throw new ApiException("Error while creating node in HBase", Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    private NodeHB getNodeHB(String nodeKey) {
        try {
            NodeHB nodeHB = (NodeHB)this.nodeDefinitionDao.get((Serializable)((Object)nodeKey), ConnectionType.HOT);
            if (nodeHB == null) {
                throw new ApiException(Response.Status.BAD_REQUEST, "Node not found");
            }
            return nodeHB;
        }
        catch (IOException e) {
            throw new ApiException("Error while fetching node from NodeHB in HBase", Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    private NodeDefinition updateExistingNode(NodeHB existingNodeHB, NodeDefinition wfNodeData) throws IOException {
        NodeDefinition existingNode = existingNodeHB.getNodeData();
        if (wfNodeData.getName() != null) {
            existingNode.setName(wfNodeData.getName());
        }
        if (wfNodeData.getType() != null) {
            existingNode.setType(wfNodeData.getType());
        }
        if (wfNodeData.getParameters() != null) {
            existingNode.setParameters(wfNodeData.getParameters());
        }
        existingNode.mergeRequestToEntity(wfNodeData);
        return existingNode;
    }

    private void updateNodeInHBase(String nodeKey, NodeDefinition nodeDefinition) {
        try {
            NodeHB nodeHB = new NodeHB();
            nodeHB.setNodeKey(nodeKey);
            nodeHB.setNodeData(nodeDefinition);
            this.nodeDefinitionDao.update((HBRecord)nodeHB, (Serializable)((Object)nodeKey), ConnectionType.HOT);
        }
        catch (IOException e) {
            throw new ApiException("Error while updating node in HBase", Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }
}

