/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.drift.api.service;

import com.flipkart.drift.api.config.DriftConfiguration;
import com.flipkart.drift.api.exception.ApiException;
import com.flipkart.drift.api.filters.RequestThreadContext;
import com.flipkart.drift.api.service.RedisPubSubService;
import com.flipkart.drift.api.service.utils.Utility;
import com.flipkart.drift.commons.model.client.request.WorkflowResumeRequest;
import com.flipkart.drift.commons.model.client.request.WorkflowStartRequest;
import com.flipkart.drift.commons.model.client.request.WorkflowTerminateRequest;
import com.flipkart.drift.commons.model.client.request.WorkflowUtilityRequest;
import com.flipkart.drift.commons.model.client.response.View;
import com.flipkart.drift.commons.model.client.response.WorkflowResponse;
import com.flipkart.drift.commons.model.client.response.WorkflowUtilityResponse;
import com.flipkart.drift.commons.model.temporal.WorkflowState;
import com.flipkart.drift.workflows.GenericWorkflow;
import com.google.inject.Inject;
import io.temporal.api.enums.v1.WorkflowIdReusePolicy;
import io.temporal.client.WorkflowClient;
import io.temporal.client.WorkflowException;
import io.temporal.client.WorkflowNotFoundException;
import io.temporal.client.WorkflowOptions;
import io.temporal.client.WorkflowStub;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.serviceclient.WorkflowServiceStubsOptions;
import java.time.Duration;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemporalService {
    private static final Logger log = LoggerFactory.getLogger(TemporalService.class);
    private final WorkflowServiceStubsOptions stubsOptions;
    private final WorkflowServiceStubs serviceStub;
    private final WorkflowClient client;
    private final RedisPubSubService redisPubSubService;
    public static final String START = "start";
    public static final String RESUME = "resume";
    private final Utility utility;
    private final DriftConfiguration driftConfiguration;

    @Inject
    public TemporalService(RedisPubSubService redisPubSubService, DriftConfiguration driftConfiguration, Utility utility) {
        this.stubsOptions = ((WorkflowServiceStubsOptions.Builder)WorkflowServiceStubsOptions.newBuilder().setTarget(driftConfiguration.getTemporalFrontEnd())).build();
        this.serviceStub = WorkflowServiceStubs.newServiceStubs((WorkflowServiceStubsOptions)this.stubsOptions);
        this.redisPubSubService = redisPubSubService;
        this.client = WorkflowClient.newInstance((WorkflowServiceStubs)this.serviceStub);
        this.utility = utility;
        this.driftConfiguration = driftConfiguration;
    }

    public WorkflowResponse startWorkflow(WorkflowStartRequest workflowStartRequest) {
        if (workflowStartRequest.getWorkflowId() == null || workflowStartRequest.getWorkflowId().isBlank()) {
            workflowStartRequest.setWorkflowId(this.utility.generateWorkflowId(null, false));
        }
        workflowStartRequest.setThreadContext(RequestThreadContext.get().getLegacyThreadContext());
        return this.executeWorkflow(workflowStartRequest);
    }

    public WorkflowResponse executeWorkflow(WorkflowStartRequest workflowStartRequest) {
        String workflowId = workflowStartRequest.getWorkflowId();
        try {
            GenericWorkflow workflow = (GenericWorkflow)this.client.newWorkflowStub(GenericWorkflow.class, WorkflowOptions.newBuilder().setWorkflowId(workflowId).setWorkflowExecutionTimeout(Duration.ofMinutes(1440L)).setTaskQueue(this.driftConfiguration.getTemporalTaskQueue()).setWorkflowIdReusePolicy(WorkflowIdReusePolicy.WORKFLOW_ID_REUSE_POLICY_TERMINATE_IF_RUNNING).build());
            this.redisPubSubService.subscribeAndExecute(workflowId, () -> {
                WorkflowClient.start(workflow::startWorkflow, (Object)workflowStartRequest);
                return null;
            }, START);
            return this.buildResponseAndReturn(workflow);
        }
        catch (WorkflowNotFoundException e) {
            throw new ApiException(Response.Status.NOT_FOUND, e.getCause() != null ? e.getCause().getMessage() : e.getMessage());
        }
        catch (WorkflowException e) {
            log.error("Encountered WorkflowException : {}", (Object)e.getMessage(), (Object)e);
            throw new ApiException(Response.Status.EXPECTATION_FAILED, e.getCause() != null ? e.getCause().getMessage() : e.getMessage());
        }
        catch (Exception e) {
            log.error("Unexpected error during workflow start: {}", (Object)e.getMessage(), (Object)e);
            throw new ApiException(Response.Status.INTERNAL_SERVER_ERROR, "Failed to start workflow: " + e.getMessage());
        }
    }

    public WorkflowResponse resumeWorkflow(WorkflowResumeRequest workflowResumeRequest) {
        try {
            workflowResumeRequest.setThreadContext(RequestThreadContext.get().getLegacyThreadContext());
            GenericWorkflow workflow = (GenericWorkflow)this.client.newWorkflowStub(GenericWorkflow.class, workflowResumeRequest.getWorkflowId());
            this.redisPubSubService.subscribeAndExecute(workflowResumeRequest.getWorkflowId(), () -> {
                workflow.resumeWorkflow(workflowResumeRequest);
                return null;
            }, RESUME);
            return this.buildResponseAndReturn(workflow);
        }
        catch (WorkflowNotFoundException e) {
            throw new ApiException(Response.Status.NOT_FOUND, e.getCause() != null ? e.getCause().getMessage() : e.getMessage());
        }
        catch (WorkflowException e) {
            log.error("Encountered WorkflowException : {}", (Object)e.getMessage(), (Object)e);
            throw new ApiException(Response.Status.EXPECTATION_FAILED, e.getCause() != null ? e.getCause().getMessage() : e.getMessage());
        }
        catch (Exception e) {
            log.error("Unexpected error during workflow resume: {}", (Object)e.getMessage(), (Object)e);
            throw new ApiException(Response.Status.INTERNAL_SERVER_ERROR, "Failed to resume workflow: " + e.getMessage());
        }
    }

    public void terminateWorkflow(WorkflowTerminateRequest workflowTerminateRequest) {
        try {
            GenericWorkflow workflow = (GenericWorkflow)this.client.newWorkflowStub(GenericWorkflow.class, workflowTerminateRequest.getWorkflowId());
            workflow.terminateWorkflow(workflowTerminateRequest);
            WorkflowStub untyped = WorkflowStub.fromTyped((Object)workflow);
            untyped.cancel();
        }
        catch (WorkflowNotFoundException e) {
            throw new ApiException(Response.Status.NOT_FOUND, e.getCause() != null ? e.getCause().getMessage() : e.getMessage());
        }
        catch (WorkflowException e) {
            log.error("Encountered WorkflowException : {}", (Object)e.getMessage(), (Object)e);
            throw new ApiException(Response.Status.EXPECTATION_FAILED, e.getCause() != null ? e.getCause().getMessage() : e.getMessage());
        }
        catch (Exception e) {
            log.error("Unexpected error during workflow termination: {}", (Object)e.getMessage(), (Object)e);
            throw new ApiException(Response.Status.INTERNAL_SERVER_ERROR, "Failed to terminate workflow: " + e.getMessage());
        }
    }

    public WorkflowState getWorkflowState(String workflowId) {
        try {
            GenericWorkflow workflow = (GenericWorkflow)this.client.newWorkflowStub(GenericWorkflow.class, workflowId);
            return workflow.getWorkflowState();
        }
        catch (WorkflowException e) {
            log.error("Encountered WorkflowException : {}", (Object)e.getMessage(), (Object)e);
            throw new ApiException(Response.Status.EXPECTATION_FAILED, e.getCause().getMessage());
        }
    }

    public WorkflowUtilityResponse executeDisconnectedNode(WorkflowUtilityRequest workflowUtilityRequest) {
        try {
            GenericWorkflow workflow = (GenericWorkflow)this.client.newWorkflowStub(GenericWorkflow.class, workflowUtilityRequest.getWorkflowId());
            workflowUtilityRequest.setThreadContext(RequestThreadContext.get().getLegacyThreadContext());
            return workflow.executeDisconnectedNode(workflowUtilityRequest);
        }
        catch (WorkflowException e) {
            log.error("Encountered WorkflowException : {}", (Object)e.getMessage(), (Object)e);
            throw new ApiException(Response.Status.EXPECTATION_FAILED, e.getCause().getMessage());
        }
    }

    private WorkflowResponse buildResponseAndReturn(GenericWorkflow workflow) {
        WorkflowState workflowState = workflow.getWorkflowState();
        View view = workflowState.getView();
        return WorkflowResponse.builder().disposition(workflowState.getDisposition()).errorMessage(workflowState.getErrorMessage()).incidentId(workflowState.getIncidentId()).workflowId(workflowState.getWorkflowId()).workflowStatus(workflowState.getStatus()).view(view).build();
    }
}

