/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.drift.api.resources;

import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Timed;
import com.flipkart.drift.api.service.TemporalService;
import com.flipkart.drift.commons.model.client.request.WorkflowResumeRequest;
import com.flipkart.drift.commons.model.client.request.WorkflowStartRequest;
import com.flipkart.drift.commons.model.client.request.WorkflowTerminateRequest;
import com.flipkart.drift.commons.model.client.request.WorkflowUtilityRequest;
import com.flipkart.drift.commons.model.client.response.WorkflowResponse;
import com.flipkart.drift.commons.model.client.response.WorkflowUtilityResponse;
import com.flipkart.drift.commons.model.temporal.WorkflowState;
import com.google.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/v3")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class WorkflowResource {
    private final TemporalService temporalService;

    @Inject
    public WorkflowResource(TemporalService temporalService) {
        this.temporalService = temporalService;
    }

    @POST
    @Timed
    @Path(value="/workflow/start")
    @ExceptionMetered
    public WorkflowResponse startWorkflow(@Valid WorkflowStartRequest workflowStartRequest) {
        return this.temporalService.startWorkflow(workflowStartRequest);
    }

    @PUT
    @Timed
    @Path(value="/workflow/resume/{workflowId}")
    @ExceptionMetered
    public WorkflowResponse resumeWorkflow(@Valid WorkflowResumeRequest workflowResumeRequest, @NotEmpty @PathParam(value="workflowId") String workflowId) {
        workflowResumeRequest.setWorkflowId(workflowId);
        return this.temporalService.resumeWorkflow(workflowResumeRequest);
    }

    @DELETE
    @Timed
    @Path(value="/workflow/terminate/{workflowId}")
    @ExceptionMetered
    public Response terminateWorkflow(@Valid WorkflowTerminateRequest workflowTerminateRequest, @NotEmpty @PathParam(value="workflowId") String workflowId) {
        if (workflowTerminateRequest == null) {
            workflowTerminateRequest = new WorkflowTerminateRequest("fallback: Workflow Completed");
        }
        workflowTerminateRequest.setWorkflowId(workflowId);
        this.temporalService.terminateWorkflow(workflowTerminateRequest);
        return Response.ok().status(200).build();
    }

    @GET
    @Timed
    @Path(value="/workflow/{workflowId}")
    @Produces(value={"application/json"})
    @ExceptionMetered
    public WorkflowState getWorkflowState(@PathParam(value="workflowId") String workflowId) {
        return this.temporalService.getWorkflowState(workflowId);
    }

    @POST
    @Timed
    @Path(value="/workflow/{workflowId}/disconnected-node/execute")
    @ExceptionMetered
    public WorkflowUtilityResponse executeDisconnectedNode(@Valid WorkflowUtilityRequest workflowUtilityRequest, @PathParam(value="workflowId") String workflowId) {
        workflowUtilityRequest.setWorkflowId(workflowId);
        return this.temporalService.executeDisconnectedNode(workflowUtilityRequest);
    }
}

