/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.drift.api.resources;

import com.codahale.metrics.annotation.Timed;
import com.flipkart.drift.api.service.builder.WorkflowDefinitionService;
import com.flipkart.drift.commons.model.node.Workflow;
import com.google.inject.Inject;
import com.wordnik.swagger.annotations.Api;
import java.io.File;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/workflowDefinition")
@Produces(value={"application/json"})
@Api(value="/workflowDefinition")
public class WorkflowDefinitionResource {
    private static final Logger log = LoggerFactory.getLogger(WorkflowDefinitionResource.class);
    private final WorkflowDefinitionService workflowDefinitionService;

    @Inject
    public WorkflowDefinitionResource(WorkflowDefinitionService workflowDefinitionService) {
        this.workflowDefinitionService = workflowDefinitionService;
    }

    @POST
    @Path(value="/")
    @Timed
    public Response addWorkflow(@NotNull Workflow workflowData) {
        try {
            Workflow workflowResponse = this.workflowDefinitionService.addWorkflow(workflowData);
            return Response.ok((Object)workflowResponse).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    @PUT
    @Path(value="/")
    @Timed
    public Response updateWorkflow(@NotNull Workflow workflowData) {
        try {
            Workflow workflowResponse = this.workflowDefinitionService.updateWorkflow(workflowData);
            return Response.ok((Object)workflowResponse).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="/{id}")
    @Timed
    public Response getWorkflowById(@NotEmpty @NotNull @PathParam(value="id") String id, @NotEmpty @NotNull @QueryParam(value="version") String version, @QueryParam(value="enrichNodeDefinition") @DefaultValue(value="false") boolean enrichNodeDefinition) {
        try {
            Workflow workflow = this.workflowDefinitionService.getWorkflowById(id, version, enrichNodeDefinition);
            return Response.ok((Object)workflow).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @Path(value="/{id}/publishWorkflow/")
    @Timed
    public Response publishWorkflow(@NotEmpty @PathParam(value="id") String id) {
        try {
            this.workflowDefinitionService.publishWorkflow(id);
            return Response.ok().build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @Path(value="/{id}/activate")
    @Timed
    public Response markActive(@NotEmpty @NotNull @PathParam(value="id") String id, @NotNull @QueryParam(value="version") Integer versionId) {
        try {
            this.workflowDefinitionService.markActive(id, versionId);
            return Response.ok().build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="/treeView/{id}")
    @Produces(value={"image/png"})
    public Response getWorkflowDiagram(@NotEmpty @NotNull @PathParam(value="id") String id, @NotEmpty @NotNull @QueryParam(value="version") String version, @DefaultValue(value="light") @QueryParam(value="mode") String mode) {
        try {
            File workflowDiagram = this.workflowDefinitionService.getWorkflowDiagram(id, version, mode);
            return Response.ok((Object)workflowDiagram, (String)"image/png").header("Content-Disposition", (Object)("inline; filename=\"" + workflowDiagram.getName() + "\"")).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }
}

