/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.drift.api.resources;

import com.codahale.metrics.annotation.Timed;
import com.flipkart.drift.api.service.builder.NodeDefinitionService;
import com.flipkart.drift.commons.model.node.NodeDefinition;
import com.google.inject.Inject;
import com.wordnik.swagger.annotations.Api;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/nodeDefinition")
@Produces(value={"application/json"})
@Api(value="/nodeDefinition")
public class NodeDefinitionResource {
    private static final Logger log = LoggerFactory.getLogger(NodeDefinitionResource.class);
    private final NodeDefinitionService nodeDefinitionService;

    @Inject
    public NodeDefinitionResource(NodeDefinitionService nodeDefinitionService) {
        this.nodeDefinitionService = nodeDefinitionService;
    }

    @POST
    @Path(value="/")
    @Timed
    public Response addNode(@NotNull NodeDefinition wfNodeData) {
        try {
            NodeDefinition wfNodeResponse = this.nodeDefinitionService.addNode(wfNodeData);
            return Response.ok((Object)wfNodeResponse).build();
        }
        catch (Exception e) {
            log.error("Error adding node", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    @PUT
    @Path(value="/")
    @Timed
    public Response updateNode(@NotNull NodeDefinition wfNodeData) {
        try {
            NodeDefinition wfNodeResponse = this.nodeDefinitionService.updateNode(wfNodeData);
            return Response.ok((Object)wfNodeResponse).build();
        }
        catch (Exception e) {
            log.error("Error updating node", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="/{id}")
    @Timed
    public Response getNodeById(@NotEmpty @NotNull @PathParam(value="id") String id, @NotEmpty @NotNull @QueryParam(value="version") String version) {
        try {
            NodeDefinition node = this.nodeDefinitionService.getNodeById(id, version);
            return Response.ok((Object)node).build();
        }
        catch (Exception e) {
            log.error("Error getting node by ID", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @Path(value="/{id}/publishNode/")
    @Timed
    public Response publishNode(@NotEmpty @NotNull @PathParam(value="id") String id) {
        try {
            this.nodeDefinitionService.publishNode(id);
            return Response.ok().build();
        }
        catch (Exception e) {
            log.error("Error publishing node", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }
}

